/*
 * Decompiled with CFR 0.152.
 */
package elki.distance;

import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.query.distance.DBIDDistanceQuery;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.AbstractDatabaseDistance;
import elki.distance.DBIDDistance;
import elki.utilities.Priority;
import elki.utilities.Util;
import elki.utilities.optionhandling.Parameterizer;
import java.util.Random;

@Priority(value=-100)
public class RandomStableDistance
extends AbstractDatabaseDistance<DBID>
implements DBIDDistance {
    public static final RandomStableDistance STATIC = new RandomStableDistance(new Random().nextLong());
    private long seed;

    public RandomStableDistance(long seed) {
        this.seed = seed;
    }

    public double distance(DBIDRef o1, DBIDRef o2) {
        int c = DBIDUtil.compare((DBIDRef)o1, (DBIDRef)o2);
        if (c == 0) {
            return 0.0;
        }
        if (c > 0) {
            return this.distance(o2, o1);
        }
        return this.pseudoRandom(this.seed, Util.mixHashCodes((int)DBIDUtil.asInteger((DBIDRef)o1), (int)DBIDUtil.asInteger((DBIDRef)o2), (int)((int)this.seed)));
    }

    private double pseudoRandom(long seed, int input) {
        long mult = 25214903917L;
        long add = 11L;
        long mask = 0xFFFFFFFFFFFFL;
        long i1 = ((long)input ^ seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        long i2 = ((long)input ^ seed >>> 16 ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        long l1 = i1 * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        long l2 = i2 * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        int r1 = (int)(l1 >>> 22);
        int r2 = (int)(l2 >>> 21);
        double random = (double)(((long)r1 << 27) + (long)r2) / 9.007199254740992E15;
        return random;
    }

    public String toString() {
        return "RandomDistance";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.seed == ((RandomStableDistance)obj).seed;
    }

    public int hashCode() {
        return (int)this.seed;
    }

    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.DBID;
    }

    public <T extends DBID> DistanceQuery<T> instantiate(Relation<T> relation) {
        return new DBIDDistanceQuery(relation, this);
    }

    public static class Par
    implements Parameterizer {
        public RandomStableDistance make() {
            return STATIC;
        }
    }
}

