/*
 * Decompiled with CFR 0.152.
 */
package elki.distance.adapter;

import elki.data.type.TypeInformation;
import elki.database.ids.DBIDRef;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.similarity.SimilarityQuery;
import elki.database.relation.Relation;
import elki.distance.AbstractDatabaseDistance;
import elki.distance.Distance;
import elki.similarity.NormalizedSimilarity;
import elki.similarity.Similarity;
import elki.utilities.ClassGenericsUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractSimilarityAdapter<O>
extends AbstractDatabaseDistance<O> {
    protected Similarity<? super O> similarityFunction;

    public AbstractSimilarityAdapter(Similarity<? super O> similarityFunction) {
        this.similarityFunction = similarityFunction;
    }

    public TypeInformation getInputTypeRestriction() {
        return this.similarityFunction.getInputTypeRestriction();
    }

    public boolean isSymmetric() {
        return this.similarityFunction.isSymmetric();
    }

    public abstract <T extends O> DistanceQuery<T> instantiate(Relation<T> var1);

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractSimilarityAdapter other = (AbstractSimilarityAdapter)obj;
        return other.similarityFunction.equals(other.similarityFunction);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.similarityFunction.hashCode();
    }

    public static abstract class Par<O, S extends Similarity<? super O>>
    implements Parameterizer {
        public static final OptionID SIMILARITY_FUNCTION_ID = new OptionID("adapter.similarityfunction", "Similarity function to derive the distance between database objects from.");
        protected S similarityFunction = null;
        protected Class<Similarity<? super O>> ARBITRARY_SIMILARITY = ClassGenericsUtil.uglyCastIntoSubclass(Similarity.class);
        protected Class<NormalizedSimilarity<? super O>> NORMALIZED_SIMILARITY = ClassGenericsUtil.uglyCastIntoSubclass(NormalizedSimilarity.class);

        public void configure(Parameterization config) {
            new ObjectParameter(SIMILARITY_FUNCTION_ID, this.getSimilarityRestriction()).grab(config, x -> {
                this.similarityFunction = x;
            });
        }

        protected abstract Class<? extends S> getSimilarityRestriction();
    }

    public static abstract class Instance<O>
    extends AbstractDatabaseDistance.Instance<O> {
        private SimilarityQuery<? super O> similarityQuery;

        public Instance(Relation<O> database, Distance<? super O> parent, SimilarityQuery<? super O> similarityQuery) {
            super(database, parent);
            this.similarityQuery = similarityQuery;
        }

        public abstract double transform(double var1);

        @Override
        public double distance(DBIDRef id1, DBIDRef id2) {
            return this.transform(this.similarityQuery.similarity(id1, id2));
        }
    }
}

