/*
 * Decompiled with CFR 0.152.
 */
package elki.similarity;

import elki.data.type.TypeInformation;
import elki.database.relation.Relation;
import elki.index.Index;
import elki.index.IndexFactory;
import elki.similarity.IndexBasedSimilarity;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractIndexBasedSimilarity<O, F extends IndexFactory<O>>
implements IndexBasedSimilarity<O> {
    protected F indexFactory;

    public AbstractIndexBasedSimilarity(F indexFactory) {
        this.indexFactory = indexFactory;
    }

    @Override
    public abstract <T extends O> Instance<T, ?> instantiate(Relation<T> var1);

    public boolean isSymmetric() {
        return true;
    }

    public final TypeInformation getInputTypeRestriction() {
        return this.indexFactory.getInputTypeRestriction();
    }

    public static abstract class Par<F extends IndexFactory<?>>
    implements Parameterizer {
        public static final OptionID INDEX_ID = new OptionID("similarityfunction.preprocessor", "Preprocessor to use.");
        protected F factory = null;

        protected void configIndexFactory(Parameterization config, Class<?> restrictionClass, Class<?> defaultClass) {
            new ObjectParameter(INDEX_ID, restrictionClass, defaultClass).grab(config, x -> {
                this.factory = x;
            });
        }
    }

    public static abstract class Instance<O, I extends Index>
    implements IndexBasedSimilarity.Instance<O, I> {
        protected final Relation<O> relation;
        protected final I index;

        public Instance(Relation<O> relation, I index) {
            this.relation = relation;
            this.index = index;
        }

        public Relation<? extends O> getRelation() {
            return this.relation;
        }

        @Override
        public I getIndex() {
            return this.index;
        }
    }
}

