/*
 * Decompiled with CFR 0.152.
 */
package elki.application.experiments;

import elki.application.AbstractApplication;
import elki.data.DoubleVector;
import elki.data.ModifiableHyperBoundingBox;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.geodesy.EarthModel;
import elki.math.geodesy.SphereUtil;
import elki.math.geodesy.SphericalVincentyEarthModel;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.jafama.FastMath;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Int. Symp. Advances in Spatial and Temporal Databases (SSTD'2013)", url="https://doi.org/10.1007/978-3-642-40235-7_9", bibkey="DBLP:conf/ssd/SchubertZK13")
public class VisualizeGeodesicDistances
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(VisualizeGeodesicDistances.class);
    private Path out;
    protected int width = 2000;
    protected int height = 1000;
    protected int steps = 10;
    protected Mode mode = Mode.XTD;
    protected EarthModel model;

    public VisualizeGeodesicDistances(Path out, int resolution, int steps, Mode mode, EarthModel model) {
        this.width = resolution;
        this.height = resolution >> 1;
        this.out = out;
        this.steps = steps;
        this.mode = mode;
        this.model = model;
    }

    public void run() {
        DoubleVector stap = DoubleVector.wrap((double[])new double[]{48.133333, 11.566667});
        DoubleVector endp = DoubleVector.wrap((double[])new double[]{40.712778, -74.005833});
        ModifiableHyperBoundingBox bb = new ModifiableHyperBoundingBox(new double[]{47.2701115, 8.9763497}, new double[]{50.5647142, 13.8396371});
        BufferedImage img = new BufferedImage(this.width, this.height, 2);
        double max = this.model.getEquatorialRadius() * Math.PI;
        int red = -65536;
        int green = -16711936;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("columns", this.width, LOG) : null;
        for (int x = 0; x < this.width; ++x) {
            double lon = (double)x * 360.0 / (double)this.width - 180.0;
            block8: for (int y = 0; y < this.height; ++y) {
                double lat = (double)y * -180.0 / (double)this.height + 90.0;
                switch (this.mode) {
                    case ATD: {
                        double atd = this.model.getEquatorialRadius() * SphereUtil.alongTrackDistanceDeg((double)stap.doubleValue(0), (double)stap.doubleValue(1), (double)endp.doubleValue(0), (double)endp.doubleValue(1), (double)lat, (double)lon);
                        if (atd < 0.0) {
                            img.setRGB(x, y, this.colorMultiply(red, -atd / max, false));
                            continue block8;
                        }
                        img.setRGB(x, y, this.colorMultiply(green, atd / max, false));
                        continue block8;
                    }
                    case XTD: {
                        double ctd = this.model.getEquatorialRadius() * SphereUtil.crossTrackDistanceDeg((double)stap.doubleValue(0), (double)stap.doubleValue(1), (double)endp.doubleValue(0), (double)endp.doubleValue(1), (double)lat, (double)lon);
                        if (ctd < 0.0) {
                            img.setRGB(x, y, this.colorMultiply(red, -ctd / max, false));
                            continue block8;
                        }
                        img.setRGB(x, y, this.colorMultiply(green, ctd / max, false));
                        continue block8;
                    }
                    case MINDIST: {
                        double dist = this.model.minDistDeg(lat, lon, bb.getMin(0), bb.getMin(1), bb.getMax(0), bb.getMax(1));
                        if (dist < 0.0) {
                            img.setRGB(x, y, this.colorMultiply(red, -dist / max, true));
                            continue block8;
                        }
                        img.setRGB(x, y, this.colorMultiply(green, dist / max, true));
                        continue block8;
                    }
                }
            }
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.ensureCompleted(prog);
        try {
            ImageIO.write((RenderedImage)img, "png", Files.newOutputStream(this.out, new OpenOption[0]));
        }
        catch (IOException e) {
            LOG.exception((Throwable)e);
        }
    }

    private int colorMultiply(int col, double reldist, boolean ceil) {
        double factor;
        double s;
        double off;
        if (this.steps > 0) {
            reldist = !ceil ? (double)(FastMath.round((double)(reldist * (double)this.steps)) / (long)this.steps) : FastMath.ceil((double)(reldist * (double)this.steps)) / (double)this.steps;
        } else if (this.steps < 0 && reldist > 0.0 && (off = Math.abs((s = reldist * (double)(-this.steps)) - (double)FastMath.round((double)s))) < (factor = (double)(-this.steps) * 1.0 / 1000.0)) {
            factor = off / factor;
            int a = col >> 24 & 0xFF;
            a = (int)((double)a * Math.sqrt(reldist)) & 0xFF;
            a = (int)((1.0 - factor) * 255.0 + factor * (double)a);
            int r = (int)(factor * (double)(col >> 16 & 0xFF));
            int g = (int)(factor * (double)(col >> 8 & 0xFF));
            int b = (int)(factor * (double)(col & 0xFF));
            return a << 24 | r << 16 | g << 8 | b;
        }
        int a = col >> 24 & 0xFF;
        int r = col >> 16 & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col & 0xFF;
        a = (int)((double)a * Math.sqrt(reldist)) & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void main(String[] args) {
        VisualizeGeodesicDistances.runCLIApplication(VisualizeGeodesicDistances.class, (String[])args);
    }

    public static class Par
    extends AbstractApplication.Par {
        public static final OptionID STEPS_ID = new OptionID("geodistvis.steps", "Number of steps for the distance map. Use negative numbers to get contour lines.");
        public static final OptionID RESOLUTION_ID = new OptionID("geodistvis.resolution", "Horizontal resolution for the image map (vertical resolution is horizonal / 2).");
        public static final OptionID MODE_ID = new OptionID("geodistvis.mode", "Visualization mode.");
        protected Path out = null;
        protected int steps = 0;
        protected int resolution = 2000;
        protected Mode mode = Mode.XTD;
        protected EarthModel model;

        public void configure(Parameterization config) {
            super.configure(config);
            this.out = super.getParameterOutputFile(config, "Output image file name.");
            ((IntParameter)new IntParameter(STEPS_ID).setOptional(true)).grab(config, x -> {
                this.steps = x;
            });
            new IntParameter(RESOLUTION_ID, 2000).grab(config, x -> {
                this.resolution = x;
            });
            new EnumParameter(MODE_ID, Mode.class, (Enum)Mode.XTD).grab(config, x -> {
                this.mode = x;
            });
            new ObjectParameter(EarthModel.MODEL_ID, EarthModel.class, SphericalVincentyEarthModel.class).grab(config, x -> {
                this.model = x;
            });
        }

        public VisualizeGeodesicDistances make() {
            return new VisualizeGeodesicDistances(this.out, this.resolution, this.steps, this.mode, this.model);
        }
    }

    public static enum Mode {
        XTD,
        ATD,
        MINDIST;

    }
}

