/*
 * Decompiled with CFR 0.152.
 */
package elki.data.projection;

import elki.data.NumberVector;
import elki.data.projection.Projection;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.math.geodesy.EarthModel;
import elki.math.geodesy.SphericalVincentyEarthModel;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class LngLatToECEFProjection<V extends NumberVector>
implements Projection<V, V> {
    EarthModel model;
    private NumberVector.Factory<V> factory;

    public LngLatToECEFProjection(EarthModel model) {
        this.model = model;
    }

    public void initialize(SimpleTypeInformation<? extends V> in) {
        VectorFieldTypeInformation vin = (VectorFieldTypeInformation)in;
        this.factory = (NumberVector.Factory)vin.getFactory();
    }

    public V project(V data) {
        return (V)this.factory.newNumberVector(this.model.latLngDegToECEF(data.doubleValue(1), data.doubleValue(0)));
    }

    public SimpleTypeInformation<? super V> getInputDataTypeInformation() {
        return TypeUtil.NUMBER_VECTOR_FIELD_2D;
    }

    public SimpleTypeInformation<V> getOutputDataTypeInformation() {
        return new VectorFieldTypeInformation(this.factory, 3, 3, this.factory.getDefaultSerializer());
    }

    public static class Par
    implements Parameterizer {
        EarthModel model;

        public void configure(Parameterization config) {
            new ObjectParameter(EarthModel.MODEL_ID, EarthModel.class, SphericalVincentyEarthModel.class).grab(config, x -> {
                this.model = x;
            });
        }

        public LngLatToECEFProjection<NumberVector> make() {
            return new LngLatToECEFProjection<NumberVector>(this.model);
        }
    }
}

