/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.transform;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.filter.AbstractStreamConversionFilter;
import elki.datasource.filter.FilterUtil;
import elki.math.geodesy.EarthModel;
import elki.math.geodesy.SphericalVincentyEarthModel;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class LngLatToECEFFilter<V extends NumberVector>
extends AbstractStreamConversionFilter<V, V> {
    private NumberVector.Factory<V> factory;
    private EarthModel model;

    public LngLatToECEFFilter(EarthModel model) {
        this.model = model;
    }

    protected V filterSingleObject(V obj) {
        return (V)this.factory.newNumberVector(this.model.latLngDegToECEF(obj.doubleValue(1), obj.doubleValue(0)));
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD_2D;
    }

    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.factory = FilterUtil.guessFactory(in);
        return new VectorFieldTypeInformation(this.factory, 3, 3, in.getSerializer());
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        private EarthModel model;

        public void configure(Parameterization config) {
            new ObjectParameter(EarthModel.MODEL_ID, EarthModel.class, SphericalVincentyEarthModel.class).grab(config, x -> {
                this.model = x;
            });
        }

        public LngLatToECEFFilter<V> make() {
            return new LngLatToECEFFilter(this.model);
        }
    }
}

