/*
 * Decompiled with CFR 0.152.
 */
package elki.math.geodesy;

import elki.math.MathUtil;
import elki.math.geodesy.EarthModel;
import elki.math.geodesy.SphereUtil;
import net.jafama.DoubleWrapper;
import net.jafama.FastMath;

public abstract class AbstractEarthModel
implements EarthModel {
    private static final int MAX_ITER = 20;
    private static final double PRECISION = 1.0E-10;
    final double a;
    final double b;
    final double f;
    final double invf;
    final double e;
    final double esq;

    public AbstractEarthModel(double a, double b, double f, double invf) {
        this.a = a;
        this.b = b;
        this.f = f;
        this.invf = invf;
        this.esq = f * (2.0 - f);
        this.e = Math.sqrt(this.esq);
    }

    @Override
    public double getEquatorialRadius() {
        return this.a;
    }

    @Override
    public double getPolarDistance() {
        return this.b;
    }

    @Override
    public double[] latLngDegToECEF(double lat, double lng) {
        return this.latLngRadToECEF(MathUtil.deg2rad((double)lat), MathUtil.deg2rad((double)lng));
    }

    @Override
    public double[] latLngDegToECEF(double lat, double lng, double h) {
        return this.latLngRadToECEF(MathUtil.deg2rad((double)lat), MathUtil.deg2rad((double)lng), h);
    }

    @Override
    public double[] latLngRadToECEF(double lat, double lng) {
        DoubleWrapper tmp = new DoubleWrapper();
        double slat = FastMath.sinAndCos((double)lat, (DoubleWrapper)tmp);
        double clat = tmp.value;
        double slng = FastMath.sinAndCos((double)lng, (DoubleWrapper)tmp);
        double clng = tmp.value;
        double v = this.a / Math.sqrt(1.0 - this.esq * slat * slat);
        return new double[]{v * clat * clng, v * clat * slng, (1.0 - this.esq) * v * slat};
    }

    @Override
    public double[] latLngRadToECEF(double lat, double lng, double h) {
        DoubleWrapper tmp = new DoubleWrapper();
        double slat = FastMath.sinAndCos((double)lat, (DoubleWrapper)tmp);
        double clat = tmp.value;
        double slng = FastMath.sinAndCos((double)lng, (DoubleWrapper)tmp);
        double clng = tmp.value;
        double v = this.a / Math.sqrt(1.0 - this.esq * slat * slat);
        return new double[]{(v + h) * clat * clng, (v + h) * clat * slng, ((1.0 - this.esq) * v + h) * slat};
    }

    @Override
    public double ecefToLatDeg(double x, double y, double z) {
        return MathUtil.rad2deg((double)this.ecefToLatRad(x, y, z));
    }

    @Override
    public double ecefToLatRad(double x, double y, double z) {
        double p = Math.sqrt(x * x + y * y);
        double plat = FastMath.atan2((double)z, (double)(p * (1.0 - this.esq)));
        int i = 0;
        double slat;
        double v;
        double lat;
        while (!(Math.abs((lat = FastMath.atan2((double)(z + this.esq * (v = this.a / Math.sqrt(1.0 - this.esq * (slat = FastMath.sin((double)plat)) * slat)) * slat), (double)p)) - plat) < 1.0E-10) && i <= 20) {
            plat = lat;
            ++i;
        }
        return lat;
    }

    @Override
    public double ecefToLngDeg(double x, double y) {
        return MathUtil.rad2deg((double)this.ecefToLngRad(x, y));
    }

    @Override
    public double ecefToLngRad(double x, double y) {
        return FastMath.atan2((double)y, (double)x);
    }

    @Override
    public double[] ecefToLatLngDegHeight(double x, double y, double z) {
        double[] ret = this.ecefToLatLngRadHeight(x, y, z);
        ret[0] = MathUtil.rad2deg((double)ret[0]);
        ret[1] = MathUtil.rad2deg((double)ret[1]);
        return ret;
    }

    @Override
    public double[] ecefToLatLngRadHeight(double x, double y, double z) {
        double lng = FastMath.atan2((double)y, (double)x);
        double p = Math.sqrt(x * x + y * y);
        double plat = FastMath.atan2((double)z, (double)(p * (1.0 - this.esq)));
        double h = 0.0;
        int i = 0;
        while (true) {
            double slat;
            double v;
            double lat;
            if (Math.abs((lat = FastMath.atan2((double)(z + this.esq * (v = this.a / Math.sqrt(1.0 - this.esq * (slat = FastMath.sin((double)plat)) * slat)) * slat), (double)p)) - plat) < 1.0E-10 || i > 20) {
                h = p / FastMath.cos((double)lat) - v;
                return new double[]{lat, lng, h};
            }
            plat = lat;
            ++i;
        }
    }

    @Override
    public double distanceDeg(double lat1, double lng1, double lat2, double lng2) {
        return this.distanceRad(MathUtil.deg2rad((double)lat1), MathUtil.deg2rad((double)lng1), MathUtil.deg2rad((double)lat2), MathUtil.deg2rad((double)lng2));
    }

    @Override
    public double distanceRad(double lat1, double lng1, double lat2, double lng2) {
        return this.b * SphereUtil.ellipsoidVincentyFormulaRad((double)this.f, (double)lat1, (double)lng1, (double)lat2, (double)lng2);
    }

    @Override
    public double minDistDeg(double plat, double plng, double rminlat, double rminlng, double rmaxlat, double rmaxlng) {
        return this.minDistRad(MathUtil.deg2rad((double)plat), MathUtil.deg2rad((double)plng), MathUtil.deg2rad((double)rminlat), MathUtil.deg2rad((double)rminlng), MathUtil.deg2rad((double)rmaxlat), MathUtil.deg2rad((double)rmaxlng));
    }

    @Override
    public double minDistRad(double plat, double plng, double rminlat, double rminlng, double rmaxlat, double rmaxlng) {
        return this.b * SphereUtil.latlngMinDistRad((double)plat, (double)plng, (double)rminlat, (double)rminlng, (double)rmaxlat, (double)rmaxlng);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [a=" + this.a + ", b=" + this.b + ", f=" + this.f + ", invf=" + this.invf + ", e=" + this.e + ", esq=" + this.esq + "]";
    }
}

