/*
 * Decompiled with CFR 0.152.
 */
package elki.index.lsh;

import elki.data.type.TypeInformation;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDBIDs;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.index.AbstractRefiningIndex;
import elki.index.IndexFactory;
import elki.index.KNNIndex;
import elki.index.RangeIndex;
import elki.index.lsh.hashfamilies.LocalitySensitiveHashFunctionFamily;
import elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;

public class InMemoryLSHIndex<V>
implements IndexFactory<V> {
    private static final Logging LOG = Logging.getLogger(InMemoryLSHIndex.class);
    LocalitySensitiveHashFunctionFamily<? super V> family;
    int l;
    int numberOfBuckets;

    public InMemoryLSHIndex(LocalitySensitiveHashFunctionFamily<? super V> family, int l, int numberOfBuckets) {
        this.family = family;
        this.l = l;
        this.numberOfBuckets = numberOfBuckets;
    }

    public Instance instantiate(Relation<V> relation) {
        return new Instance(relation, this.family.generateHashFunctions(relation, this.l), this.numberOfBuckets);
    }

    public TypeInformation getInputTypeRestriction() {
        return this.family.getInputTypeRestriction();
    }

    public static class Par<V>
    implements Parameterizer {
        public static final OptionID FAMILY_ID = new OptionID("lsh.family", "Hash function family to use for LSH.");
        public static final OptionID L_ID = new OptionID("lsh.tables", "Number of hash tables to use.");
        public static final OptionID BUCKETS_ID = new OptionID("lsh.buckets", "Number of hash buckets to use.");
        LocalitySensitiveHashFunctionFamily<? super V> family;
        int l;
        int numberOfBuckets;

        public void configure(Parameterization config) {
            new ObjectParameter(FAMILY_ID, LocalitySensitiveHashFunctionFamily.class).grab(config, x -> {
                this.family = x;
            });
            ((IntParameter)new IntParameter(L_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.l = x;
            });
            ((IntParameter)((IntParameter)new IntParameter(BUCKETS_ID).setDefaultValue((Object)7919)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.numberOfBuckets = x;
            });
        }

        public InMemoryLSHIndex<V> make() {
            return new InMemoryLSHIndex<V>(this.family, this.l, this.numberOfBuckets);
        }
    }

    public class Instance
    extends AbstractRefiningIndex<V>
    implements KNNIndex<V>,
    RangeIndex<V> {
        ArrayList<? extends LocalitySensitiveHashFunction<? super V>> hashfunctions;
        ArrayList<Int2ObjectOpenHashMap<DBIDs>> hashtables;
        private int numberOfBuckets;

        public Instance(Relation<V> relation, ArrayList<? extends LocalitySensitiveHashFunction<? super V>> hashfunctions, int numberOfBuckets) {
            super(relation);
            this.hashfunctions = hashfunctions;
            this.numberOfBuckets = numberOfBuckets;
        }

        public void initialize() {
            Int2ObjectOpenHashMap<DBIDs> table;
            int i;
            int numhash = this.hashfunctions.size();
            this.hashtables = new ArrayList(numhash);
            for (int i2 = 0; i2 < numhash; ++i2) {
                this.hashtables.add((Int2ObjectOpenHashMap<DBIDs>)new Int2ObjectOpenHashMap(this.numberOfBuckets));
            }
            double[] buf = new double[this.hashfunctions.get(0).getNumberOfProjections()];
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Building LSH index", this.relation.size(), LOG) : null;
            int expect = Math.max(2, (int)Math.ceil((double)this.relation.size() / (double)this.numberOfBuckets));
            DBIDIter iter = this.relation.getDBIDs().iter();
            while (iter.valid()) {
                Object obj = this.relation.get((DBIDRef)iter);
                for (i = 0; i < numhash; ++i) {
                    LocalitySensitiveHashFunction<Object> hashfunc;
                    int hash;
                    int bucket;
                    table = this.hashtables.get(i);
                    DBIDs cur = (DBIDs)table.get(bucket = (hash = (hashfunc = this.hashfunctions.get(i)).hashObject(obj, buf)) % this.numberOfBuckets);
                    if (cur == null) {
                        table.put(bucket, (Object)DBIDUtil.deref((DBIDRef)iter));
                        continue;
                    }
                    if (cur.size() > 1) {
                        ((ModifiableDBIDs)cur).add((DBIDRef)iter);
                        continue;
                    }
                    ArrayModifiableDBIDs newbuck = DBIDUtil.newArray((int)expect);
                    newbuck.addDBIDs(cur);
                    newbuck.add((DBIDRef)iter);
                    table.put(bucket, (Object)newbuck);
                }
                LOG.incrementProcessed((AbstractProgress)progress);
                iter.advance();
            }
            LOG.ensureCompleted(progress);
            if (LOG.isStatistics()) {
                int min = Integer.MAX_VALUE;
                int max = 0;
                for (i = 0; i < numhash; ++i) {
                    table = this.hashtables.get(i);
                    for (DBIDs set : table.values()) {
                        int size = set.size();
                        min = size < min ? size : min;
                        max = size > max ? size : max;
                    }
                }
                LOG.statistics((Statistic)new LongStatistic(((Object)((Object)this)).getClass().getName() + ".fill.min", (long)min));
                LOG.statistics((Statistic)new LongStatistic(((Object)((Object)this)).getClass().getName() + ".fill.max", (long)max));
                LOG.statistics((Statistic)new LongStatistic(((Object)((Object)this)).getClass().getName() + ".hashtables", (long)this.hashtables.size()));
            }
        }

        public Logging getLogger() {
            return LOG;
        }

        public KNNSearcher<V> kNNByObject(DistanceQuery<V> distanceQuery, int maxk, int flags) {
            return (flags & 4) == 0 && InMemoryLSHIndex.this.family.isCompatible(distanceQuery.getDistance()) ? new LSHKNNQuery(distanceQuery) : null;
        }

        public RangeSearcher<V> rangeByObject(DistanceQuery<V> distanceQuery, double maxradius, int flags) {
            return (flags & 4) == 0 && !InMemoryLSHIndex.this.family.isCompatible(distanceQuery.getDistance()) ? new LSHRangeQuery(distanceQuery) : null;
        }

        protected DBIDs getCandidates(V obj) {
            HashSetModifiableDBIDs candidates = null;
            int numhash = this.hashtables.size();
            double[] buf = new double[this.hashfunctions.get(0).getNumberOfProjections()];
            for (int i = 0; i < numhash; ++i) {
                LocalitySensitiveHashFunction hashfunc;
                int hash;
                int bucket;
                Int2ObjectOpenHashMap<DBIDs> table = this.hashtables.get(i);
                DBIDs cur = (DBIDs)table.get(bucket = (hash = (hashfunc = this.hashfunctions.get(i)).hashObject(obj, buf)) % this.numberOfBuckets);
                if (cur == null) continue;
                if (candidates == null) {
                    candidates = DBIDUtil.newHashSet((int)(cur.size() * numhash));
                }
                candidates.addDBIDs(cur);
            }
            return candidates == null ? DBIDUtil.EMPTYDBIDS : candidates;
        }

        protected class LSHRangeQuery
        extends AbstractRefiningIndex.AbstractRefiningQuery
        implements RangeSearcher<V> {
            public LSHRangeQuery(DistanceQuery<V> distanceQuery) {
                super((AbstractRefiningIndex)Instance.this, distanceQuery);
            }

            public ModifiableDoubleDBIDList getRange(V obj, double range, ModifiableDoubleDBIDList result) {
                DBIDs candidates = Instance.this.getCandidates(obj);
                DBIDIter iter = candidates.iter();
                while (iter.valid()) {
                    double dist = this.distanceQuery.distance(obj, (DBIDRef)iter);
                    super.incRefinements(1);
                    if (dist <= range) {
                        result.add(dist, (DBIDRef)iter);
                    }
                    iter.advance();
                }
                return result;
            }
        }

        protected class LSHKNNQuery
        extends AbstractRefiningIndex.AbstractRefiningQuery
        implements KNNSearcher<V> {
            public LSHKNNQuery(DistanceQuery<V> distanceQuery) {
                super((AbstractRefiningIndex)Instance.this, distanceQuery);
            }

            public KNNList getKNN(V obj, int k) {
                DBIDs candidates = Instance.this.getCandidates(obj);
                KNNHeap heap = DBIDUtil.newHeap((int)k);
                DBIDIter iter = candidates.iter();
                while (iter.valid()) {
                    double dist = this.distanceQuery.distance(obj, (DBIDRef)iter);
                    super.incRefinements(1);
                    heap.insert(dist, (DBIDRef)iter);
                    iter.advance();
                }
                return heap.toKNNList();
            }
        }
    }
}

