/*
 * Decompiled with CFR 0.152.
 */
package elki.index.lsh.hashfamilies;

import elki.data.NumberVector;
import elki.data.projection.random.RandomProjectionFamily;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.index.lsh.hashfamilies.LocalitySensitiveHashFunctionFamily;
import elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import elki.index.lsh.hashfunctions.MultipleProjectionsLocalitySensitiveHashFunction;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Random;

public abstract class AbstractProjectedHashFunctionFamily
implements LocalitySensitiveHashFunctionFamily<NumberVector> {
    protected RandomFactory random;
    protected RandomProjectionFamily proj;
    protected double width;
    protected int k;

    public AbstractProjectedHashFunctionFamily(RandomFactory random, RandomProjectionFamily proj, double width, int k) {
        this.random = random;
        this.proj = proj;
        this.width = width;
        this.k = k;
    }

    @Override
    public ArrayList<? extends LocalitySensitiveHashFunction<? super NumberVector>> generateHashFunctions(Relation<? extends NumberVector> relation, int l) {
        int dim = RelationUtil.dimensionality(relation);
        ArrayList<MultipleProjectionsLocalitySensitiveHashFunction> ps = new ArrayList<MultipleProjectionsLocalitySensitiveHashFunction>(l);
        Random rnd = this.random.getSingleThreadedRandom();
        for (int i = 0; i < l; ++i) {
            RandomProjectionFamily.Projection mat = this.proj.generateProjection(dim, this.k);
            ps.add(new MultipleProjectionsLocalitySensitiveHashFunction(mat, this.width, rnd));
        }
        return ps;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    public static abstract class Par
    implements Parameterizer {
        public static final OptionID RANDOM_ID = new OptionID("lsh.projection.random", "Random seed for generating the projections.");
        public static final OptionID WIDTH_ID = new OptionID("lsh.projection.width", "Bin width for random projections.");
        public static final OptionID NUMPROJ_ID = new OptionID("lsh.projection.projections", "Number of projections to use for each hash function.");
        RandomFactory random;
        double width;
        int k;

        public void configure(Parameterization config) {
            new RandomParameter(RANDOM_ID, RandomFactory.DEFAULT).grab(config, x -> {
                this.random = x;
            });
            ((DoubleParameter)new DoubleParameter(WIDTH_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.width = x;
            });
            ((IntParameter)new IntParameter(NUMPROJ_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }
    }
}

