/*
 * Decompiled with CFR 0.152.
 */
package elki.index.lsh.hashfamilies;

import elki.data.NumberVector;
import elki.data.projection.random.RandomProjectionFamily;
import elki.data.projection.random.SimplifiedRandomHyperplaneProjectionFamily;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.CosineDistance;
import elki.distance.Distance;
import elki.index.lsh.hashfamilies.LocalitySensitiveHashFunctionFamily;
import elki.index.lsh.hashfunctions.CosineLocalitySensitiveHashFunction;
import elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.LessEqualConstraint;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;

@References(value={@Reference(authors="M. S. Charikar", title="Similarity estimation techniques from rounding algorithms", booktitle="Proc. 34th ACM Symposium on Theory of Computing, STOC'02", url="https://doi.org/10.1145/509907.509965", bibkey="DBLP:conf/stoc/Charikar02"), @Reference(authors="M. Henzinger", title="Finding near-duplicate web pages: a large-scale evaluation of algorithms", booktitle="Proc. 29th ACM Conf. Research and Development in Information Retrieval (SIGIR 2006)", url="https://doi.org/10.1145/1148170.1148222", bibkey="DBLP:conf/sigir/Henzinger06")})
public class CosineHashFunctionFamily
implements LocalitySensitiveHashFunctionFamily<NumberVector> {
    private RandomProjectionFamily proj;
    private int k;

    public CosineHashFunctionFamily(int k, RandomFactory random) {
        this.proj = new SimplifiedRandomHyperplaneProjectionFamily(random);
        this.k = k;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public ArrayList<? extends LocalitySensitiveHashFunction<? super NumberVector>> generateHashFunctions(Relation<? extends NumberVector> relation, int l) {
        int dim = RelationUtil.dimensionality(relation);
        ArrayList<CosineLocalitySensitiveHashFunction> ps = new ArrayList<CosineLocalitySensitiveHashFunction>(l);
        for (int i = 0; i < l; ++i) {
            RandomProjectionFamily.Projection projection = this.proj.generateProjection(dim, this.k);
            ps.add(new CosineLocalitySensitiveHashFunction(projection));
        }
        return ps;
    }

    @Override
    public boolean isCompatible(Distance<?> df) {
        return df instanceof CosineDistance;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID RANDOM_ID = new OptionID("lsh.projection.random", "Random seed for generating the projections.");
        public static final OptionID NUMPROJ_ID = new OptionID("lsh.projection.projections", "Number of projections to use for each hash function.");
        RandomFactory random;
        int k;

        public void configure(Parameterization config) {
            new RandomParameter(RANDOM_ID).grab(config, x -> {
                this.random = x;
            });
            ((IntParameter)((IntParameter)new IntParameter(NUMPROJ_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).addConstraint((ParameterConstraint)new LessEqualConstraint(32))).grab(config, x -> {
                this.k = x;
            });
        }

        public CosineHashFunctionFamily make() {
            return new CosineHashFunctionFamily(this.k, this.random);
        }
    }
}

