/*
 * Decompiled with CFR 0.152.
 */
package elki.index.lsh.hashfamilies;

import elki.data.projection.random.CauchyRandomProjectionFamily;
import elki.data.projection.random.RandomProjectionFamily;
import elki.distance.Distance;
import elki.distance.minkowski.ManhattanDistance;
import elki.index.lsh.hashfamilies.AbstractProjectedHashFunctionFamily;
import elki.utilities.documentation.Reference;
import elki.utilities.random.RandomFactory;

@Reference(authors="M. Datar, N. Immorlica, P. Indyk, V. S. Mirrokni", title="Locality-sensitive hashing scheme based on p-stable distributions", booktitle="Proc. 20th Annual Symposium on Computational Geometry", url="https://doi.org/10.1145/997817.997857", bibkey="DBLP:conf/compgeom/DatarIIM04")
public class ManhattanHashFunctionFamily
extends AbstractProjectedHashFunctionFamily {
    public ManhattanHashFunctionFamily(RandomFactory random, double width, int k) {
        super(random, (RandomProjectionFamily)new CauchyRandomProjectionFamily(random), width, k);
    }

    @Override
    public boolean isCompatible(Distance<?> df) {
        return ManhattanDistance.class.isInstance(df);
    }

    public static class Par
    extends AbstractProjectedHashFunctionFamily.Par {
        public ManhattanHashFunctionFamily make() {
            return new ManhattanHashFunctionFamily(this.random, this.width, this.k);
        }
    }
}

