/*
 * Decompiled with CFR 0.152.
 */
package elki.index.lsh.hashfunctions;

import elki.data.NumberVector;
import elki.data.projection.random.RandomProjectionFamily;
import elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import elki.utilities.documentation.Reference;

@Reference(authors="M. S. Charikar", title="Similarity estimation techniques from rounding algorithms", booktitle="Proc. 34th ACM Symposium on Theory of Computing, STOC'02", url="https://doi.org/10.1145/509907.509965", bibkey="DBLP:conf/stoc/Charikar02")
public class CosineLocalitySensitiveHashFunction
implements LocalitySensitiveHashFunction<NumberVector> {
    private RandomProjectionFamily.Projection projection;

    public CosineLocalitySensitiveHashFunction(RandomProjectionFamily.Projection projection) {
        this.projection = projection;
    }

    @Override
    public int hashObject(NumberVector obj) {
        double[] buf = this.projection.project(obj);
        int hashValue = 0;
        int i = 0;
        int j = 1;
        while (i < buf.length) {
            if (buf[i] > 0.0) {
                hashValue |= j;
            }
            ++i;
            j <<= 1;
        }
        return hashValue;
    }

    @Override
    public int hashObject(NumberVector obj, double[] buf) {
        this.projection.project(obj, buf);
        int hashValue = 0;
        int i = 0;
        int j = 1;
        while (i < buf.length) {
            if (buf[i] > 0.0) {
                hashValue |= j;
            }
            ++i;
            j <<= 1;
        }
        return hashValue;
    }

    @Override
    public int getNumberOfProjections() {
        return this.projection.getOutputDimensionality();
    }
}

