/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants;

import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.distance.Distance;
import elki.index.tree.BreadthFirstEnumeration;
import elki.index.tree.IndexTree;
import elki.index.tree.IndexTreePath;
import elki.index.tree.LeafEntry;
import elki.index.tree.Node;
import elki.index.tree.metrical.MetricalIndexTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.MTreeSettings;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistanceEntry;
import elki.logging.Logging;
import elki.logging.statistics.Counter;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.persistent.PageFile;
import elki.utilities.io.FormatUtil;
import elki.utilities.pairs.DoubleIntPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractMTree<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry, S extends MTreeSettings<O, N, E>>
extends MetricalIndexTree<O, N, E> {
    private static final boolean EXTRA_INTEGRITY_CHECKS = false;
    protected S settings;
    public Statistics statistics = new Statistics();

    public AbstractMTree(PageFile<N> pagefile, S settings) {
        super(pagefile);
        this.settings = settings;
    }

    @Override
    public final Distance<? super O> getDistance() {
        return ((MTreeSettings)this.settings).distanceFunction;
    }

    public String toString() {
        int dirNodes = 0;
        int leafNodes = 0;
        int objects = 0;
        int levels = 0;
        AbstractMTreeNode node = (AbstractMTreeNode)this.getNode(this.getRootID());
        while (!node.isLeaf()) {
            if (node.getNumEntries() <= 0) continue;
            MTreeEntry entry = (MTreeEntry)node.getEntry(0);
            node = (AbstractMTreeNode)this.getNode(entry);
            ++levels;
        }
        StringBuilder result = new StringBuilder(1000);
        BreadthFirstEnumeration enumeration = new BreadthFirstEnumeration((IndexTree)this, this.getRootPath());
        while (enumeration.hasNext()) {
            IndexTreePath path = enumeration.next();
            MTreeEntry entry = (MTreeEntry)path.getEntry();
            if (entry instanceof LeafEntry) {
                ++objects;
                result.append("\n    ").append(entry.toString());
                continue;
            }
            node = (AbstractMTreeNode)this.getNode(entry);
            result.append("\n\n").append((Object)node).append(", numEntries = ").append(node.getNumEntries()).append('\n').append(entry.toString());
            if (node.isLeaf()) {
                ++leafNodes;
                continue;
            }
            ++dirNodes;
        }
        result.append(((Object)((Object)this)).getClass().getName()).append(" hat ").append(levels + 1).append(" Ebenen \nDirCapacity = ").append(this.dirCapacity).append("\nLeafCapacity = ").append(this.leafCapacity).append('\n').append(dirNodes).append(" Directory Nodes\n").append(leafNodes).append(" Leaf Nodes\n").append(objects).append(" Objects");
        return result.toString();
    }

    public void insert(E entry, boolean withPreInsert) {
        Logging log = this.getLogger();
        if (log.isDebugging()) {
            log.debugFine((CharSequence)("insert " + entry.getRoutingObjectID()));
        }
        if (!this.initialized) {
            this.initialize(entry);
        }
        IndexTreePath subtree = ((MTreeSettings)this.settings).insertStrategy.choosePath(this, entry);
        if (log.isDebugging()) {
            log.debugFine((CharSequence)("insertion-subtree " + subtree));
        }
        MTreeEntry parentEntry = (MTreeEntry)subtree.getEntry();
        entry.setParentDistance(this.distance((DBIDRef)parentEntry.getRoutingObjectID(), (DBIDRef)entry.getRoutingObjectID()));
        if (withPreInsert) {
            this.preInsert(entry);
        }
        AbstractMTreeNode parent = (AbstractMTreeNode)this.getNode(parentEntry);
        parent.addEntry(entry);
        this.writeNode((Node)parent);
        this.adjustTree(subtree);
        this.doExtraIntegrityChecks();
    }

    public void insertAll(List<E> entries) {
        if (!this.initialized && !entries.isEmpty()) {
            this.initialize((MTreeEntry)entries.get(0));
        }
        for (MTreeEntry entry : entries) {
            this.insert(entry, false);
        }
    }

    protected final void createEmptyRoot(E exampleLeaf) {
        this.writeNode((Node)((AbstractMTreeNode)this.createNewLeafNode()));
    }

    protected final List<DoubleIntPair> getSortedEntries(N node, DBID q) {
        ArrayList<DoubleIntPair> result = new ArrayList<DoubleIntPair>();
        for (int i = 0; i < node.getNumEntries(); ++i) {
            MTreeEntry entry = (MTreeEntry)node.getEntry(i);
            double distance = this.distance((DBIDRef)entry.getRoutingObjectID(), (DBIDRef)q);
            double radius = entry.getCoveringRadius();
            double minDist = radius > distance ? 0.0 : distance - radius;
            result.add(new DoubleIntPair(minDist, i));
        }
        Collections.sort(result);
        return result;
    }

    public abstract double distance(DBIDRef var1, DBIDRef var2);

    public final double distance(E e1, E e2) {
        return this.distance((DBIDRef)e1.getRoutingObjectID(), (DBIDRef)e2.getRoutingObjectID());
    }

    protected abstract E createNewDirectoryEntry(N var1, DBID var2, double var3);

    private void adjustTree(IndexTreePath<E> subtree) {
        Logging log = this.getLogger();
        if (log.isDebugging()) {
            log.debugFine((CharSequence)("Adjust tree " + subtree + "\n"));
        }
        int nodeIndex = subtree.getIndex();
        AbstractMTreeNode node = (AbstractMTreeNode)this.getNode((MTreeEntry)subtree.getEntry());
        if (this.hasOverflow(node)) {
            MTreeEntry e;
            Assignments assignments = ((MTreeSettings)this.settings).splitStrategy.split(this, node);
            AbstractMTreeNode newNode = node.isLeaf() ? (AbstractMTreeNode)this.createNewLeafNode() : (AbstractMTreeNode)this.createNewDirectoryNode();
            ArrayList<MTreeEntry> entries1 = new ArrayList<MTreeEntry>(assignments.getFirstAssignments().size());
            ArrayList<MTreeEntry> entries2 = new ArrayList<MTreeEntry>(assignments.getSecondAssignments().size());
            for (DistanceEntry ent : assignments.getFirstAssignments()) {
                e = (MTreeEntry)ent.getEntry();
                e.setParentDistance(ent.getDistance());
                entries1.add(e);
            }
            for (DistanceEntry ent : assignments.getSecondAssignments()) {
                e = (MTreeEntry)ent.getEntry();
                e.setParentDistance(ent.getDistance());
                entries2.add(e);
            }
            node.splitTo(newNode, entries1, entries2);
            this.writeNode((Node)node);
            this.writeNode((Node)newNode);
            if (log.isDebuggingFine()) {
                log.debugFine((CharSequence)new StringBuilder(1000).append("Split Node ").append(node.getPageID()).append(" (").append(((Object)((Object)this)).getClass()).append(')').append(FormatUtil.NEWLINE).append("      newNode ").append(newNode.getPageID()).append(FormatUtil.NEWLINE).append("      firstPromoted ").append(assignments.getFirstRoutingObject()).append(FormatUtil.NEWLINE).append("      firstAssignments(").append(node.getPageID()).append(") ").append(assignments.getFirstAssignments()).append(FormatUtil.NEWLINE).append("      firstCR ").append(assignments.computeFirstCover(node.isLeaf())).append(FormatUtil.NEWLINE).append("      secondPromoted ").append(assignments.getSecondRoutingObject()).append(FormatUtil.NEWLINE).append("      secondAssignments(").append(newNode.getPageID()).append(") ").append(assignments.getSecondAssignments()).append(FormatUtil.NEWLINE).append("      secondCR ").append(assignments.computeSecondCover(node.isLeaf())).append(FormatUtil.NEWLINE));
            }
            if (this.isRoot((Node)node)) {
                IndexTreePath<E> newRootPath = this.createNewRoot(node, newNode, assignments.getFirstRoutingObject(), assignments.getSecondRoutingObject());
                this.adjustTree(newRootPath);
            } else {
                MTreeEntry parentEntry = (MTreeEntry)subtree.getParentPath().getEntry();
                AbstractMTreeNode parent = (AbstractMTreeNode)this.getNode(parentEntry);
                if (log.isDebugging()) {
                    log.debugFine((CharSequence)("parent " + (Object)((Object)parent)));
                }
                double parentDistance2 = this.distance((DBIDRef)parentEntry.getRoutingObjectID(), (DBIDRef)assignments.getSecondRoutingObject());
                parent.addEntry(this.createNewDirectoryEntry(newNode, assignments.getSecondRoutingObject(), parentDistance2));
                double parentDistance1 = this.distance((DBIDRef)parentEntry.getRoutingObjectID(), (DBIDRef)assignments.getFirstRoutingObject());
                node.adjustEntry((MTreeEntry)parent.getEntry(nodeIndex), assignments.getFirstRoutingObject(), parentDistance1, this);
                this.writeNode((Node)parent);
                this.adjustTree(subtree.getParentPath());
            }
        } else if (!this.isRoot((Node)node)) {
            MTreeEntry parentEntry = (MTreeEntry)subtree.getParentPath().getEntry();
            AbstractMTreeNode parent = (AbstractMTreeNode)this.getNode(parentEntry);
            MTreeEntry entry = (MTreeEntry)parent.getEntry(subtree.getIndex());
            boolean changed = node.adjustEntry(entry, entry.getRoutingObjectID(), entry.getParentDistance(), this);
            if (changed) {
                this.writeNode((Node)parent);
                this.adjustTree(subtree.getParentPath());
            }
        } else {
            MTreeEntry rootEntry = (MTreeEntry)this.getRootEntry();
            node.adjustEntry(rootEntry, rootEntry.getRoutingObjectID(), rootEntry.getParentDistance(), this);
        }
    }

    private boolean hasOverflow(N node) {
        return node.getNumEntries() == (node.isLeaf() ? this.leafCapacity : this.dirCapacity);
    }

    private IndexTreePath<E> createNewRoot(N oldRoot, N newNode, DBID firstRoutingObjectID, DBID secondRoutingObjectID) {
        AbstractMTreeNode root = (AbstractMTreeNode)this.createNewDirectoryNode();
        this.writeNode((Node)root);
        oldRoot.setPageID(root.getPageID());
        if (!oldRoot.isLeaf()) {
            for (int i = 0; i < oldRoot.getNumEntries(); ++i) {
                this.writeNode((Node)((AbstractMTreeNode)this.getNode((MTreeEntry)oldRoot.getEntry(i))));
            }
        }
        root.setPageID(this.getRootID());
        root.addEntry(this.createNewDirectoryEntry(oldRoot, firstRoutingObjectID, 0.0));
        root.addEntry(this.createNewDirectoryEntry(newNode, secondRoutingObjectID, 0.0));
        this.writeNode((Node)root);
        this.writeNode((Node)oldRoot);
        this.writeNode((Node)newNode);
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine((CharSequence)("Create new Root: ID=" + root.getPageID() + "\nchild1 " + oldRoot + "\nchild2 " + newNode));
        }
        return new IndexTreePath(null, (Object)((MTreeEntry)this.getRootEntry()), -1);
    }

    @Override
    public List<E> getLeaves() {
        ArrayList<MTreeEntry> result = new ArrayList<MTreeEntry>();
        BreadthFirstEnumeration enumeration = new BreadthFirstEnumeration((IndexTree)this, this.getRootPath());
        while (enumeration.hasNext()) {
            IndexTreePath path = enumeration.next();
            MTreeEntry entry = (MTreeEntry)path.getEntry();
            if (entry instanceof LeafEntry || !((AbstractMTreeNode)this.getNode(entry)).isLeaf()) continue;
            result.add(entry);
        }
        return result;
    }

    public int getHeight() {
        int levels = 0;
        AbstractMTreeNode node = (AbstractMTreeNode)this.getNode(this.getRootID());
        while (!node.isLeaf()) {
            if (node.getNumEntries() <= 0) continue;
            node = (AbstractMTreeNode)this.getNode((MTreeEntry)node.getEntry(0));
            ++levels;
        }
        return levels;
    }

    public void logStatistics() {
        super.logStatistics();
        Logging log = this.getLogger();
        if (log.isStatistics()) {
            log.statistics((Statistic)new LongStatistic(((Object)((Object)this)).getClass().getName() + ".height", (long)this.getHeight()));
            this.statistics.logStatistics();
        }
    }

    protected void doExtraIntegrityChecks() {
    }

    public class Statistics {
        protected final Counter distanceCalcs;
        protected final Counter knnQueries;
        protected final Counter rangeQueries;

        public Statistics() {
            Logging log = AbstractMTree.this.getLogger();
            this.distanceCalcs = log.isStatistics() ? log.newCounter(this.getClass().getName() + ".distancecalcs") : null;
            this.knnQueries = log.isStatistics() ? log.newCounter(this.getClass().getName() + ".knnqueries") : null;
            this.rangeQueries = log.isStatistics() ? log.newCounter(this.getClass().getName() + ".rangequeries") : null;
        }

        public void countDistanceCalculation() {
            if (this.distanceCalcs != null) {
                this.distanceCalcs.increment();
            }
        }

        public void countKNNQuery() {
            if (this.knnQueries != null) {
                this.knnQueries.increment();
            }
        }

        public void countRangeQuery() {
            if (this.rangeQueries != null) {
                this.rangeQueries.increment();
            }
        }

        public void logStatistics() {
            Logging log = AbstractMTree.this.getLogger();
            if (AbstractMTree.this.statistics.distanceCalcs != null) {
                log.statistics((Statistic)AbstractMTree.this.statistics.distanceCalcs);
            }
            if (AbstractMTree.this.statistics.knnQueries != null) {
                log.statistics((Statistic)AbstractMTree.this.statistics.knnQueries);
            }
            if (AbstractMTree.this.statistics.rangeQueries != null) {
                log.statistics((Statistic)AbstractMTree.this.statistics.rangeQueries);
            }
        }
    }
}

