/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants;

import elki.data.type.TypeInformation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.index.PagedIndexFactory;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.MTreeSettings;
import elki.index.tree.metrical.mtreevariants.strategies.insert.MTreeInsert;
import elki.index.tree.metrical.mtreevariants.strategies.insert.MinimumEnlargementInsert;
import elki.index.tree.metrical.mtreevariants.strategies.split.MLBDistSplit;
import elki.index.tree.metrical.mtreevariants.strategies.split.MTreeSplit;
import elki.persistent.PageFileFactory;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractMTreeFactory<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry, S extends MTreeSettings<O, N, E>>
extends PagedIndexFactory<O> {
    protected S settings;

    public AbstractMTreeFactory(PageFileFactory<?> pageFileFactory, S settings) {
        super(pageFileFactory);
        this.settings = settings;
    }

    public TypeInformation getInputTypeRestriction() {
        return ((MTreeSettings)this.settings).distanceFunction.getInputTypeRestriction();
    }

    public static abstract class Par<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry, S extends MTreeSettings<O, N, E>>
    extends PagedIndexFactory.Par<O> {
        public static final OptionID DISTANCE_FUNCTION_ID = new OptionID("mtree.distancefunction", "Distance function to determine the distance between database objects.");
        public static final OptionID SPLIT_STRATEGY_ID = new OptionID("mtree.split", "Split strategy to use for constructing the M-tree.");
        public static final OptionID INSERT_STRATEGY_ID = new OptionID("mtree.insert", "Insertion strategy to use for constructing the M-tree.");
        protected S settings;

        public void configure(Parameterization config) {
            super.configure(config);
            this.settings = this.makeSettings();
            new ObjectParameter(DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                ((MTreeSettings)this.settings).distanceFunction = x;
            });
            new ObjectParameter(SPLIT_STRATEGY_ID, MTreeSplit.class, MLBDistSplit.class).grab(config, x -> {
                ((MTreeSettings)this.settings).splitStrategy = x;
            });
            new ObjectParameter(INSERT_STRATEGY_ID, MTreeInsert.class, MinimumEnlargementInsert.class).grab(config, x -> {
                ((MTreeSettings)this.settings).insertStrategy = x;
            });
        }

        protected abstract S makeSettings();

        public abstract AbstractMTreeFactory<O, N, E, ?> make();
    }
}

