/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants;

import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.index.tree.DirectoryEntry;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MTreeDirectoryEntry
implements DirectoryEntry,
MTreeEntry {
    private static final long serialVersionUID = 3L;
    private int id;
    private DBID routingObjectID;
    private double parentDistance;
    private double coveringRadius;

    public MTreeDirectoryEntry() {
    }

    public MTreeDirectoryEntry(DBID objectID, double parentDistance, int nodeID, double coveringRadius) {
        this.id = nodeID;
        this.routingObjectID = objectID;
        this.parentDistance = parentDistance;
        this.coveringRadius = coveringRadius;
    }

    public int getPageID() {
        return this.id;
    }

    @Override
    public final double getCoveringRadius() {
        return this.coveringRadius;
    }

    @Override
    public final boolean setCoveringRadius(double coveringRadius) {
        if (this.coveringRadius == coveringRadius) {
            return false;
        }
        this.coveringRadius = coveringRadius;
        return true;
    }

    @Override
    public final DBID getRoutingObjectID() {
        return this.routingObjectID;
    }

    @Override
    public final boolean setRoutingObjectID(DBID objectID) {
        if (objectID == this.routingObjectID || DBIDUtil.equal((DBIDRef)objectID, (DBIDRef)this.routingObjectID)) {
            return false;
        }
        this.routingObjectID = objectID;
        return true;
    }

    @Override
    public final double getParentDistance() {
        return this.parentDistance;
    }

    @Override
    public final boolean setParentDistance(double parentDistance) {
        if (this.parentDistance == parentDistance) {
            return false;
        }
        this.parentDistance = parentDistance;
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeInt(DBIDUtil.asInteger((DBIDRef)this.routingObjectID));
        out.writeDouble(this.parentDistance);
        out.writeDouble(this.coveringRadius);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.routingObjectID = DBIDUtil.importInteger((int)in.readInt());
        this.parentDistance = in.readDouble();
        this.coveringRadius = in.readDouble();
    }

    public String toString() {
        return "MTreeNode(" + this.id + " dbid=" + DBIDUtil.toString((DBIDRef)this.routingObjectID) + ")";
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.id == ((MTreeDirectoryEntry)o).id;
    }

    public int hashCode() {
        return this.id;
    }
}

