/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants;

import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.index.tree.LeafEntry;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MTreeLeafEntry
implements LeafEntry,
MTreeEntry {
    private static final long serialVersionUID = 3L;
    private DBID id;
    private double parentDistance;

    public MTreeLeafEntry() {
    }

    public MTreeLeafEntry(DBID objectID, double parentDistance) {
        this.id = objectID;
        this.parentDistance = parentDistance;
    }

    public DBID getDBID() {
        return this.id;
    }

    @Override
    public final DBID getRoutingObjectID() {
        return this.getDBID();
    }

    @Override
    public final boolean setRoutingObjectID(DBID objectID) {
        throw new UnsupportedOperationException("Leaf entries should not be assigned a routing object.");
    }

    @Override
    public final double getParentDistance() {
        return this.parentDistance;
    }

    @Override
    public final boolean setParentDistance(double parentDistance) {
        if (this.parentDistance == parentDistance) {
            return false;
        }
        this.parentDistance = parentDistance;
        return true;
    }

    @Override
    public double getCoveringRadius() {
        return 0.0;
    }

    @Override
    public boolean setCoveringRadius(double coveringRadius) {
        throw new UnsupportedOperationException("This entry is not a directory entry!");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(DBIDUtil.asInteger((DBIDRef)this.id));
        out.writeDouble(this.parentDistance);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = DBIDUtil.importInteger((int)in.readInt());
        this.parentDistance = in.readDouble();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && DBIDUtil.equal((DBIDRef)this.id, (DBIDRef)((MTreeLeafEntry)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

