/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees;

import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.KNNList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.MTreeSettings;
import elki.index.tree.metrical.mtreevariants.query.MTreeKNNByDBID;
import elki.persistent.PageFile;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMkTree<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry, S extends MTreeSettings<O, N, E>>
extends AbstractMTree<O, N, E, S> {
    protected KNNSearcher<DBIDRef> knnq;
    private DistanceQuery<O> distanceQuery;

    public AbstractMkTree(Relation<O> relation, PageFile<N> pagefile, S settings) {
        super(pagefile, settings);
        this.distanceQuery = this.getDistance().instantiate(relation);
        this.knnq = new MTreeKNNByDBID<O>(this, this.distanceQuery);
    }

    @Override
    public double distance(DBIDRef id1, DBIDRef id2) {
        if (id1 == null || id2 == null) {
            return Double.NaN;
        }
        if (DBIDUtil.equal((DBIDRef)id1, (DBIDRef)id2)) {
            return 0.0;
        }
        this.statistics.countDistanceCalculation();
        return this.distanceQuery.distance(id1, id2);
    }

    public abstract DoubleDBIDList reverseKNNQuery(DBIDRef var1, int var2);

    @Deprecated
    protected final Map<DBID, KNNList> batchNN(N node, DBIDs ids, int kmax) {
        HashMap<DBID, KNNList> res = new HashMap<DBID, KNNList>(ids.size());
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref((DBIDRef)iter);
            res.put(id, this.knnq.getKNN((Object)id, kmax));
            iter.advance();
        }
        return res;
    }
}

