/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees;

import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNList;
import elki.database.relation.Relation;
import elki.index.tree.TreeIndexHeader;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.AbstractMkTree;
import elki.index.tree.metrical.mtreevariants.mktrees.MkTreeHeader;
import elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import elki.persistent.PageFile;
import java.util.List;
import java.util.Map;

public abstract class AbstractMkTreeUnified<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry, S extends MkTreeSettings<O, N, E>>
extends AbstractMkTree<O, N, E, S> {
    public AbstractMkTreeUnified(Relation<O> relation, PageFile<N> pagefile, S settings) {
        super(relation, pagefile, settings);
    }

    protected TreeIndexHeader createHeader() {
        return new MkTreeHeader(this.getPageSize(), this.dirCapacity, this.leafCapacity, ((MkTreeSettings)this.settings).kmax);
    }

    @Override
    public void insertAll(List<E> entries) {
        if (entries.isEmpty()) {
            return;
        }
        if (!this.initialized) {
            this.initialize((MTreeEntry)entries.get(0));
        }
        ArrayModifiableDBIDs ids = DBIDUtil.newArray((int)entries.size());
        for (MTreeEntry entry : entries) {
            ids.add((DBIDRef)entry.getRoutingObjectID());
            super.insert(entry, false);
        }
        Map<DBID, KNNList> knnLists = this.batchNN((AbstractMTreeNode)this.getNode(this.getRootID()), (DBIDs)ids, ((MkTreeSettings)this.settings).kmax);
        this.kNNdistanceAdjustment((MTreeEntry)this.getRootEntry(), knnLists);
        this.doExtraIntegrityChecks();
    }

    protected abstract void kNNdistanceAdjustment(E var1, Map<DBID, KNNList> var2);

    public int getKmax() {
        return ((MkTreeSettings)this.settings).kmax;
    }
}

