/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import elki.database.relation.Relation;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeFactory;
import elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeIndex;
import elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeNode;
import elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeSettings;
import elki.persistent.PageFile;
import elki.persistent.PageFileFactory;
import elki.utilities.ClassGenericsUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.IntParameter;

public class MkAppTreeFactory<O>
extends AbstractMTreeFactory<O, MkAppTreeNode<O>, MkAppEntry, MkAppTreeSettings<O>> {
    public MkAppTreeFactory(PageFileFactory<?> pageFileFactory, MkAppTreeSettings<O> settings) {
        super(pageFileFactory, settings);
    }

    public MkAppTreeIndex<O> instantiate(Relation<O> relation) {
        PageFile pagefile = this.makePageFile(this.getNodeClass());
        return new MkAppTreeIndex<O>(relation, pagefile, (MkAppTreeSettings)this.settings);
    }

    protected Class<MkAppTreeNode<O>> getNodeClass() {
        return ClassGenericsUtil.uglyCastIntoSubclass(MkAppTreeNode.class);
    }

    public static class Par<O>
    extends AbstractMTreeFactory.Par<O, MkAppTreeNode<O>, MkAppEntry, MkAppTreeSettings<O>> {
        public static final OptionID NOLOG_ID = new OptionID("mkapp.nolog", "Flag to indicate that the approximation is done in the ''normal'' space instead of the log-log space (which is default).");
        public static final OptionID K_ID = new OptionID("mkapp.k", "positive integer specifying the maximum number k of reverse k nearest neighbors to be supported.");
        public static final OptionID P_ID = new OptionID("mkapp.p", "positive integer specifying the order of the polynomial approximation.");

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                ((MkAppTreeSettings)this.settings).kmax = x;
            });
            ((IntParameter)new IntParameter(P_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                ((MkAppTreeSettings)this.settings).p = x;
            });
            new Flag(NOLOG_ID).grab(config, x -> {
                ((MkAppTreeSettings)this.settings).log = !x;
            });
        }

        @Override
        public MkAppTreeFactory<O> make() {
            return new MkAppTreeFactory(this.pageFileFactory, (MkAppTreeSettings)this.settings);
        }

        @Override
        protected MkAppTreeSettings<O> makeSettings() {
            return new MkAppTreeSettings();
        }
    }
}

