/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.relation.Relation;
import elki.index.KNNIndex;
import elki.index.RKNNIndex;
import elki.index.RangeIndex;
import elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppLeafEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTree;
import elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeNode;
import elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeSettings;
import elki.index.tree.metrical.mtreevariants.query.MTreeKNNByDBID;
import elki.index.tree.metrical.mtreevariants.query.MTreeKNNByObject;
import elki.index.tree.metrical.mtreevariants.query.MTreeRangeByDBID;
import elki.index.tree.metrical.mtreevariants.query.MTreeRangeByObject;
import elki.index.tree.metrical.mtreevariants.query.MkTreeRKNNQuery;
import elki.persistent.PageFile;
import java.util.ArrayList;
import java.util.List;

public class MkAppTreeIndex<O>
extends MkAppTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
RKNNIndex<O> {
    private Relation<O> relation;

    public MkAppTreeIndex(Relation<O> relation, PageFile<MkAppTreeNode<O>> pageFile, MkAppTreeSettings<O> settings) {
        super(relation, pageFile, settings);
        this.relation = relation;
    }

    protected MkAppEntry createNewLeafEntry(DBID id, O object, double parentDistance) {
        return new MkAppLeafEntry(id, parentDistance, null);
    }

    public void initialize() {
        super.initialize();
        ArrayList<MkAppEntry> objs = new ArrayList<MkAppEntry>(this.relation.size());
        DBIDIter iter = this.relation.iterDBIDs();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref((DBIDRef)iter);
            Object object = this.relation.get((DBIDRef)id);
            objs.add(this.createNewLeafEntry(id, object, Double.NaN));
            iter.advance();
        }
        this.insertAll((List<MkAppEntry>)objs);
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeKNNByObject<O>(this, distanceQuery) : null;
    }

    public KNNSearcher<DBIDRef> kNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeKNNByDBID<O>(this, distanceQuery) : null;
    }

    public RangeSearcher<O> rangeByObject(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeRangeByObject<O>(this, distanceQuery) : null;
    }

    public RangeSearcher<DBIDRef> rangeByDBID(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeRangeByDBID<O>(this, distanceQuery) : null;
    }

    public RKNNSearcher<O> rkNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    public RKNNSearcher<DBIDRef> rkNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MkTreeRKNNQuery<O>(this, distanceQuery) : null;
    }
}

