/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import elki.database.ids.DBID;
import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkapp.PolynomialApproximation;
import elki.logging.Logging;
import elki.utilities.io.FormatUtil;
import java.text.NumberFormat;
import java.util.Arrays;

class MkAppTreeNode<O>
extends AbstractMTreeNode<O, MkAppTreeNode<O>, MkAppEntry> {
    private static final long serialVersionUID = 2L;
    private static final Logging LOG = Logging.getLogger(MkAppTreeNode.class);

    public MkAppTreeNode() {
    }

    public MkAppTreeNode(int capacity, boolean isLeaf) {
        super(capacity, isLeaf);
    }

    protected PolynomialApproximation knnDistanceApproximation() {
        int p_max = 0;
        double[] b = null;
        for (int i = 0; i < this.getNumEntries(); ++i) {
            MkAppEntry entry = (MkAppEntry)this.getEntry(i);
            PolynomialApproximation approximation = entry.getKnnDistanceApproximation();
            if (b == null) {
                p_max = approximation.getPolynomialOrder();
                b = new double[p_max];
            }
            for (int p = 0; p < p_max; ++p) {
                int n = p;
                b[n] = b[n] + approximation.getB(p);
            }
        }
        int p = 0;
        while (p < p_max) {
            int n = p++;
            b[n] = b[n] / (double)p_max;
        }
        if (LOG.isDebuggingFine()) {
            LOG.fine((CharSequence)("b: " + FormatUtil.format((double[])b, (NumberFormat)FormatUtil.NF4)));
        }
        return new PolynomialApproximation(b);
    }

    @Override
    public boolean adjustEntry(MkAppEntry entry, DBID routingObjectID, double parentDistance, AbstractMTree<O, MkAppTreeNode<O>, MkAppEntry, ?> mTree) {
        super.adjustEntry(entry, routingObjectID, parentDistance, mTree);
        return true;
    }

    @Override
    protected void integrityCheckParameters(MkAppEntry parentEntry, MkAppTreeNode<O> parent, int index, AbstractMTree<O, MkAppTreeNode<O>, MkAppEntry, ?> mTree) {
        super.integrityCheckParameters(parentEntry, parent, index, mTree);
        MkAppEntry entry = (MkAppEntry)parent.getEntry(index);
        PolynomialApproximation approximation_soll = this.knnDistanceApproximation();
        PolynomialApproximation approximation_ist = entry.getKnnDistanceApproximation();
        if (!Arrays.equals(approximation_ist.getCoefficients(), approximation_soll.getCoefficients())) {
            String soll = approximation_soll.toString();
            String ist = entry.getKnnDistanceApproximation().toString();
            throw new RuntimeException("Wrong polynomial approximation in node " + parent.getPageID() + " at index " + index + " (child " + entry + ")\nsoll: " + soll + ",\n ist: " + ist);
        }
    }
}

