/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import elki.utilities.io.FormatUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import net.jafama.FastMath;

public class PolynomialApproximation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private double[] b;

    public PolynomialApproximation() {
    }

    public PolynomialApproximation(double[] b) {
        this.b = b;
    }

    public double getB(int p) {
        return this.b[p];
    }

    public double[] getCoefficients() {
        double[] result = new double[this.b.length];
        System.arraycopy(this.b, 0, result, 0, this.b.length);
        return result;
    }

    public int getPolynomialOrder() {
        return this.b.length;
    }

    public double getValueAt(int k) {
        double result = 0.0;
        double log_k = FastMath.log((double)k);
        double acc = 1.0;
        for (int p = 0; p < this.b.length; ++p) {
            result += this.b[p] * acc;
            acc *= log_k;
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.b.length);
        for (double aB : this.b) {
            out.writeDouble(aB);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.b = new double[in.readInt()];
        for (int p = 0; p < this.b.length; ++p) {
            this.b[p] = in.readDouble();
        }
    }

    public String toString() {
        return FormatUtil.format((double[])this.b, (NumberFormat)FormatUtil.NF4);
    }
}

