/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jafama.FastMath;

public class ApproximationLine
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private double m;
    private double t;
    private int k_0;

    public ApproximationLine() {
    }

    public ApproximationLine(int k_0, double m, double t) {
        this.k_0 = k_0;
        this.m = m;
        this.t = t;
    }

    public double getM() {
        return this.m;
    }

    public double getT() {
        return this.t;
    }

    public int getK_0() {
        return this.k_0;
    }

    public double getValueAt(int k) {
        if (k < this.k_0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.m * FastMath.log((double)k) + this.t;
    }

    public double getApproximatedKnnDistance(int k) {
        if (k < this.k_0) {
            return 0.0;
        }
        return FastMath.exp((double)this.getValueAt(k));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.m);
        out.writeDouble(this.t);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.m = in.readDouble();
        this.t = in.readDouble();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApproximationLine that = (ApproximationLine)o;
        return Double.compare(that.m, this.m) == 0 && Double.compare(that.t, this.t) == 0;
    }

    public int hashCode() {
        long temp = this.m != 0.0 ? Double.doubleToLongBits(this.m) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.t != 0.0 ? Double.doubleToLongBits(this.t) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "m = " + this.m + ", t = " + this.t + " k_0 " + this.k_0;
    }
}

