/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

public class ConvexHull {
    private int[] lowerHull;
    private int[] upperHull;
    private int l;
    private int u;

    public ConvexHull(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y have different lengths!");
        }
        this.lowerHull = new int[x.length];
        this.upperHull = new int[x.length];
        this.u = 1;
        this.l = 1;
        for (int i = 1; i < x.length; ++i) {
            this.lowerHull[this.l] = i;
            while (this.l >= 2 && (y[this.lowerHull[this.l]] - y[this.lowerHull[this.l - 1]]) / (x[this.lowerHull[this.l]] - x[this.lowerHull[this.l - 1]]) <= (y[this.lowerHull[this.l - 1]] - y[this.lowerHull[this.l - 2]]) / (x[this.lowerHull[this.l - 1]] - x[this.lowerHull[this.l - 2]])) {
                this.lowerHull[this.l - 1] = this.lowerHull[this.l];
                --this.l;
            }
            ++this.l;
            this.upperHull[this.u] = i;
            while (this.u >= 2 && (y[this.upperHull[this.u]] - y[this.upperHull[this.u - 1]]) / (x[this.upperHull[this.u]] - x[this.upperHull[this.u - 1]]) >= (y[this.upperHull[this.u - 1]] - y[this.upperHull[this.u - 2]]) / (x[this.upperHull[this.u - 1]] - x[this.upperHull[this.u - 2]])) {
                this.upperHull[this.u - 1] = this.upperHull[this.u];
                --this.u;
            }
            ++this.u;
        }
    }

    public int[] getLowerHull() {
        return this.lowerHull;
    }

    public int[] getUpperHull() {
        return this.upperHull;
    }

    public int getNumberOfPointsInLowerHull() {
        return this.l;
    }

    public int getNumberOfPointsInUpperHull() {
        return this.u;
    }
}

