/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBID;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDBIDs;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.relation.Relation;
import elki.index.tree.metrical.mtreevariants.MTreeLeafEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.AbstractMkTree;
import elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import elki.index.tree.metrical.mtreevariants.mktrees.mkcop.ApproximationLine;
import elki.index.tree.metrical.mtreevariants.mktrees.mkcop.ConvexHull;
import elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPDirectoryEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPLeafEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPTreeNode;
import elki.index.tree.metrical.mtreevariants.query.MTreeSearchCandidate;
import elki.logging.Logging;
import elki.persistent.PageFile;
import elki.utilities.datastructures.heap.ComparableMinHeap;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FormatUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.jafama.FastMath;

public abstract class MkCoPTree<O>
extends AbstractMkTree<O, MkCoPTreeNode<O>, MkCoPEntry, MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry>> {
    private static final Logging LOG = Logging.getLogger(MkCoPTree.class);
    private double[] log_k;

    public MkCoPTree(Relation<O> relation, PageFile<MkCoPTreeNode<O>> pagefile, MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry> settings) {
        super(relation, pagefile, settings);
        this.log_k = new double[settings.kmax];
        for (int k = 1; k <= settings.kmax; ++k) {
            this.log_k[k - 1] = FastMath.log((double)k);
        }
    }

    protected void preInsert(MkCoPEntry entry) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    public void insert(MkCoPEntry entry, boolean withPreInsert) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    public void insertAll(List<MkCoPEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)("insert " + entries + "\n"));
        }
        if (!this.initialized) {
            this.initialize(entries.get(0));
        }
        ArrayModifiableDBIDs ids = DBIDUtil.newArray((int)entries.size());
        for (MkCoPEntry entry : entries) {
            ids.add((DBIDRef)entry.getRoutingObjectID());
            super.insert(entry, false);
        }
        Map<DBID, KNNList> knnLists = this.batchNN((MkCoPTreeNode)this.getNode(this.getRootID()), (DBIDs)ids, ((MkTreeSettings)this.settings).kmax);
        this.adjustApproximatedKNNDistances((MkCoPEntry)this.getRootEntry(), knnLists);
        this.doExtraIntegrityChecks();
    }

    @Override
    public DoubleDBIDList reverseKNNQuery(DBIDRef id, int k) {
        if (k > ((MkTreeSettings)this.settings).kmax) {
            throw new IllegalArgumentException("Parameter k has to be less or equal than parameter kmax of the MCop-Tree!");
        }
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        ArrayModifiableDBIDs candidates = DBIDUtil.newArray();
        this.doReverseKNNQuery(k, id, result, (ModifiableDBIDs)candidates);
        Map<DBID, KNNList> knnLists = this.batchNN((MkCoPTreeNode)this.getNode(this.getRootID()), (DBIDs)candidates, k);
        result.sort();
        DBIDMIter iter = candidates.iter();
        while (iter.valid()) {
            DBID cid = DBIDUtil.deref((DBIDRef)iter);
            KNNList cands = knnLists.get(cid);
            DoubleDBIDListIter iter2 = cands.iter();
            while (iter2.valid()) {
                if (DBIDUtil.equal((DBIDRef)id, (DBIDRef)iter2)) {
                    result.add(iter2.doubleValue(), (DBIDRef)cid);
                    break;
                }
                iter2.advance();
            }
            iter.advance();
        }
        result.sort();
        return result;
    }

    public int getKmax() {
        return ((MkTreeSettings)this.settings).kmax;
    }

    protected void initializeCapacities(MkCoPEntry exampleLeaf) {
        int distanceSize = 8;
        double overhead = 12.125;
        if ((double)this.getPageSize() - overhead < 0.0) {
            throw new AbortException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)((double)this.getPageSize() - overhead) / (8 + distanceSize + distanceSize + 10) + 1;
        if (this.dirCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            LOG.warning((CharSequence)("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1)));
        }
        this.leafCapacity = (int)((double)this.getPageSize() - overhead) / (4 + distanceSize + 20) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            LOG.warning((CharSequence)("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1)));
        }
        this.initialized = true;
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)("Directory Capacity: " + (this.dirCapacity - 1) + "\nLeaf Capacity:    " + (this.leafCapacity - 1)));
        }
    }

    private void doReverseKNNQuery(int k, DBIDRef q, ModifiableDoubleDBIDList result, ModifiableDBIDs candidates) {
        ComparableMinHeap pq = new ComparableMinHeap();
        pq.add((Comparable)new MTreeSearchCandidate(0.0, this.getRootID(), null, Double.NaN));
        while (!pq.isEmpty()) {
            double approximatedKnnDist_cons;
            double distance;
            MkCoPEntry entry;
            int i;
            MTreeSearchCandidate pqNode = (MTreeSearchCandidate)pq.poll();
            MkCoPTreeNode node = (MkCoPTreeNode)this.getNode(pqNode.nodeID);
            if (!node.isLeaf()) {
                for (i = 0; i < node.getNumEntries(); ++i) {
                    entry = (MkCoPEntry)node.getEntry(i);
                    distance = this.distance((DBIDRef)entry.getRoutingObjectID(), q);
                    double minDist = entry.getCoveringRadius() > distance ? 0.0 : distance - entry.getCoveringRadius();
                    if (!(minDist <= (approximatedKnnDist_cons = entry.approximateConservativeKnnDistance(k)))) continue;
                    pq.add((Comparable)new MTreeSearchCandidate(minDist, this.getPageID(entry), entry.getRoutingObjectID(), Double.NaN));
                }
                continue;
            }
            for (i = 0; i < node.getNumEntries(); ++i) {
                double approximatedKnnDist_prog;
                entry = (MkCoPLeafEntry)node.getEntry(i);
                distance = this.distance((DBIDRef)((MTreeLeafEntry)((Object)entry)).getRoutingObjectID(), q);
                if (distance <= (approximatedKnnDist_prog = ((MkCoPLeafEntry)entry).approximateProgressiveKnnDistance(k))) {
                    result.add(distance, (DBIDRef)((MTreeLeafEntry)((Object)entry)).getRoutingObjectID());
                    continue;
                }
                approximatedKnnDist_cons = ((MkCoPLeafEntry)entry).approximateConservativeKnnDistance(k);
                double diff = distance - approximatedKnnDist_cons;
                if (!(diff <= 1.0E-10)) continue;
                candidates.add((DBIDRef)((MTreeLeafEntry)((Object)entry)).getRoutingObjectID());
            }
        }
    }

    private void adjustApproximatedKNNDistances(MkCoPEntry entry, Map<DBID, KNNList> knnLists) {
        int i;
        MkCoPTreeNode node = (MkCoPTreeNode)this.getNode(entry);
        if (node.isLeaf()) {
            for (i = 0; i < node.getNumEntries(); ++i) {
                MkCoPLeafEntry leafEntry = (MkCoPLeafEntry)node.getEntry(i);
                this.approximateKnnDistances(leafEntry, knnLists.get(leafEntry.getRoutingObjectID()));
            }
        } else {
            for (i = 0; i < node.getNumEntries(); ++i) {
                MkCoPEntry dirEntry = (MkCoPEntry)node.getEntry(i);
                this.adjustApproximatedKNNDistances(dirEntry, knnLists);
            }
        }
        ApproximationLine approx = node.conservativeKnnDistanceApproximation(((MkTreeSettings)this.settings).kmax);
        entry.setConservativeKnnDistanceApproximation(approx);
    }

    private double ssqerr(int k0, int kmax, double[] logk, double[] log_kDist, double m, double t) {
        int k = kmax - k0;
        double result = 0.0;
        for (int i = 0; i < k; ++i) {
            double h = log_kDist[i] - m * logk[i] - t;
            result += h * h;
        }
        return result;
    }

    private double optimize(int k0, int kmax, double sumx, double sumx2, double xp, double yp, double sumxy, double sumy) {
        int k = kmax - k0 + 1;
        return (sumxy - xp * sumy - yp * sumx + (double)k * xp * yp) / (sumx2 - 2.0 * sumx * xp + (double)k * xp * xp);
    }

    private void approximateKnnDistances(MkCoPLeafEntry entry, KNNList knnDistances) {
        StringBuilder msg;
        StringBuilder stringBuilder = msg = LOG.isDebugging() ? new StringBuilder(1000) : null;
        if (msg != null) {
            msg.append("knnDistances ").append(knnDistances);
        }
        DoubleDBIDListIter iter = knnDistances.iter();
        int k_0 = 0;
        iter.seek(0);
        while (iter.valid() && iter.doubleValue() == 0.0) {
            ++k_0;
            iter.advance();
        }
        double[] log_k = new double[((MkTreeSettings)this.settings).kmax - k_0];
        System.arraycopy(this.log_k, k_0, log_k, 0, ((MkTreeSettings)this.settings).kmax - k_0);
        double sum_log_kDist = 0.0;
        double sum_log_k_kDist = 0.0;
        double[] log_kDist = new double[((MkTreeSettings)this.settings).kmax - k_0];
        iter.seek(k_0);
        int i = 0;
        while (iter.valid()) {
            double logd = log_kDist[i] = FastMath.log((double)iter.doubleValue());
            sum_log_kDist += logd;
            sum_log_k_kDist += logd * log_k[i];
            iter.advance();
            ++i;
        }
        double sum_log_k = 0.0;
        double sum_log_k2 = 0.0;
        for (int i2 = 0; i2 < log_k.length; ++i2) {
            double logki = log_k[i2];
            sum_log_k += logki;
            sum_log_k2 += logki * logki;
        }
        if (msg != null) {
            msg.append("\nk_0 ").append(k_0).append("\nk_max ").append(((MkTreeSettings)this.settings).kmax).append("\nlog_k(").append(log_k.length).append(") ").append(FormatUtil.format((double[])log_k)).append("\nsum_log_k ").append(sum_log_k).append("\nsum_log_k^2 ").append(sum_log_k2).append("\nkDists ").append(knnDistances).append("\nlog_kDist(").append(log_kDist.length).append(") ").append(FormatUtil.format((double[])log_kDist)).append("\nsum_log_kDist ").append(sum_log_kDist).append("\nsum_log_k_kDist ").append(sum_log_k_kDist);
        }
        ConvexHull convexHull = new ConvexHull(log_k, log_kDist);
        ApproximationLine conservative = this.approximateUpperHull(convexHull, log_k, log_kDist);
        ApproximationLine c2 = this.approximateUpperHullPaper(convexHull, log_k, sum_log_k, sum_log_k2, log_kDist, sum_log_kDist, sum_log_k_kDist);
        double err1 = this.ssqerr(k_0, ((MkTreeSettings)this.settings).kmax, log_k, log_kDist, conservative.getM(), conservative.getT());
        double err2 = this.ssqerr(k_0, ((MkTreeSettings)this.settings).kmax, log_k, log_kDist, c2.getM(), c2.getT());
        if (msg != null) {
            msg.append("err1 ").append(err1).append("err2 ").append(err2);
        }
        if (err1 > err2 && err1 - err2 > 1.0E-9) {
            StringBuilder warning = new StringBuilder(10000);
            int u = convexHull.getNumberOfPointsInUpperHull();
            int[] upperHull = convexHull.getUpperHull();
            warning.append("\nentry ").append(entry.getRoutingObjectID()).append("\nlower Hull ").append(convexHull.getNumberOfPointsInLowerHull()).append(' ').append(FormatUtil.format((int[])convexHull.getLowerHull())).append("\nupper Hull ").append(convexHull.getNumberOfPointsInUpperHull()).append(' ').append(FormatUtil.format((int[])convexHull.getUpperHull())).append("\nerr1 ").append(err1).append("\nerr2 ").append(err2).append("\nconservative1 ").append(conservative).append("\nconservative2 ").append(c2);
            for (int i3 = 0; i3 < u; ++i3) {
                warning.append("\nlog_k[").append(upperHull[i3]).append("] = ").append(log_k[upperHull[i3]]).append("\nlog_kDist[").append(upperHull[i3]).append("] = ").append(log_kDist[upperHull[i3]]);
            }
            LOG.warning((CharSequence)warning.toString());
        }
        ApproximationLine progressive = this.approximateLowerHull(convexHull, log_k, sum_log_k, sum_log_k2, log_kDist, sum_log_kDist, sum_log_k_kDist);
        entry.setConservativeKnnDistanceApproximation(conservative);
        entry.setProgressiveKnnDistanceApproximation(progressive);
        if (msg != null) {
            LOG.debugFine((CharSequence)msg.toString());
        }
    }

    private ApproximationLine approximateLowerHull(ConvexHull convexHull, double[] log_k, double sum_log_k, double sum_log_k2, double[] log_kDist, double sum_log_kDist, double sum_log_k_kDist) {
        int[] lowerHull = convexHull.getLowerHull();
        int l = convexHull.getNumberOfPointsInLowerHull();
        int k_0 = ((MkTreeSettings)this.settings).kmax - lowerHull.length + 1;
        double low_error = Double.MAX_VALUE;
        double low_m = 0.0;
        double low_t = 0.0;
        for (int i = 1; i < l; ++i) {
            double cur_m = (log_kDist[lowerHull[i]] - log_kDist[lowerHull[i - 1]]) / (log_k[lowerHull[i]] - log_k[lowerHull[i - 1]]);
            double cur_t = log_kDist[lowerHull[i]] - cur_m * log_k[lowerHull[i]];
            double cur_error = this.ssqerr(k_0, ((MkTreeSettings)this.settings).kmax, log_k, log_kDist, cur_m, cur_t);
            if (!(cur_error < low_error)) continue;
            low_error = cur_error;
            low_m = cur_m;
            low_t = cur_t;
        }
        boolean is_right = true;
        for (int i = 0; i < l; ++i) {
            double cur_error;
            double cur_m = this.optimize(k_0, ((MkTreeSettings)this.settings).kmax, sum_log_k, sum_log_k2, log_k[lowerHull[i]], log_kDist[lowerHull[i]], sum_log_k_kDist, sum_log_kDist);
            double cur_t = log_kDist[lowerHull[i]] - cur_m * log_k[lowerHull[i]];
            if ((i == 0 || log_kDist[lowerHull[i - 1]] >= log_kDist[lowerHull[i]] - cur_m * (log_k[lowerHull[i]] - log_k[lowerHull[i - 1]])) && (i == l - 1 || log_kDist[lowerHull[i + 1]] >= log_kDist[lowerHull[i]] + cur_m * (log_k[lowerHull[i + 1]] - log_k[lowerHull[i]])) && (cur_error = this.ssqerr(k_0, ((MkTreeSettings)this.settings).kmax, log_k, log_kDist, cur_m, cur_t)) < low_error) {
                low_error = cur_error;
                low_m = cur_m;
                low_t = cur_t;
            }
            if (i > 0 && log_kDist[lowerHull[i - 1]] < log_kDist[lowerHull[i]] - cur_m * (log_k[lowerHull[i]] - log_k[lowerHull[i - 1]]) || is_right) continue;
            LOG.warning((CharSequence)"ERROR lower: The bisection search will not work properly!");
            if (i < l - 1 && log_kDist[lowerHull[i + 1]] < log_kDist[lowerHull[i]] + cur_m * (log_k[lowerHull[i + 1]] - log_k[lowerHull[i]])) continue;
            is_right = false;
        }
        return new ApproximationLine(k_0, low_m, low_t);
    }

    private ApproximationLine approximateUpperHull(ConvexHull convexHull, double[] log_k, double[] log_kDist) {
        StringBuilder msg = LOG.isDebugging() ? new StringBuilder(1000) : null;
        int[] upperHull = convexHull.getUpperHull();
        int u = convexHull.getNumberOfPointsInUpperHull();
        int k_0 = ((MkTreeSettings)this.settings).kmax - upperHull.length + 1;
        ApproximationLine approx = null;
        double error = Double.POSITIVE_INFINITY;
        for (int i = 0; i < u - 1; ++i) {
            int ii = upperHull[i];
            int jj = upperHull[i + 1];
            double current_m = (log_kDist[jj] - log_kDist[ii]) / (log_k[jj] - log_k[ii]);
            double current_t = log_kDist[ii] - current_m * log_k[ii];
            ApproximationLine current_approx = new ApproximationLine(k_0, current_m, current_t);
            if (msg != null) {
                msg.append("\nlog_kDist[").append(jj).append("] ").append(log_kDist[jj]).append("\nlog_kDist[").append(ii).append("] ").append(log_kDist[ii]).append("\nlog_k[").append(jj).append("] ").append(log_k[jj]).append("\nlog_k[").append(ii).append("] ").append(log_k[ii]).append('\n').append(log_kDist[jj] - log_kDist[ii]).append("\ncurrent_approx_").append(i).append(' ').append(current_approx);
            }
            boolean ok = true;
            double currentError = 0.0;
            for (int k = k_0; k <= ((MkTreeSettings)this.settings).kmax; ++k) {
                double appDist = current_approx.getValueAt(k);
                if (appDist < log_kDist[k - k_0] && log_kDist[k - k_0] - appDist > 1.0E-9) {
                    ok = false;
                    break;
                }
                currentError += appDist - log_kDist[k - k_0];
            }
            if (!ok || !(currentError < error)) continue;
            approx = current_approx;
            error = currentError;
        }
        if (msg != null) {
            LOG.debugFine((CharSequence)msg.append("\nupper Approx ").append(approx).toString());
        }
        return approx;
    }

    private ApproximationLine approximateUpperHullPaper(ConvexHull convexHull, double[] log_k, double sum_log_k, double sum_log_k2, double[] log_kDist, double sum_log_kDist, double sum_log_k_kDist) {
        StringBuilder msg = LOG.isDebugging() ? new StringBuilder(1000) : null;
        int[] upperHull = convexHull.getUpperHull();
        int u = convexHull.getNumberOfPointsInUpperHull();
        ArrayList<Integer> marked = new ArrayList<Integer>();
        int k_0 = ((MkTreeSettings)this.settings).kmax - upperHull.length + 1;
        int a = u / 2;
        while (marked.size() != u) {
            boolean lessThanSuc;
            marked.add(a);
            double x_a = log_k[upperHull[a]];
            double y_a = log_kDist[upperHull[a]];
            double m_a = this.optimize(k_0, ((MkTreeSettings)this.settings).kmax, sum_log_k, sum_log_k2, x_a, y_a, sum_log_k_kDist, sum_log_kDist);
            double t_a = y_a - m_a * x_a;
            if (msg != null) {
                msg.append("\na=").append(a).append(" m_a=").append(m_a).append(", t_a=").append(t_a).append("\n err ").append(this.ssqerr(k_0, ((MkTreeSettings)this.settings).kmax, log_k, log_kDist, m_a, m_a));
            }
            double x_p = a == 0 ? Double.NaN : log_k[upperHull[a - 1]];
            double y_p = a == 0 ? Double.NaN : log_kDist[upperHull[a - 1]];
            double x_s = a == u ? Double.NaN : log_k[upperHull[a + 1]];
            double y_s = a == u ? Double.NaN : log_kDist[upperHull[a + 1]];
            boolean lessThanPre = a == 0 || y_p <= m_a * x_p + t_a;
            boolean bl = lessThanSuc = a == u || y_s <= m_a * x_s + t_a;
            if (lessThanPre && lessThanSuc) {
                ApproximationLine appr = new ApproximationLine(k_0, m_a, t_a);
                if (msg != null) {
                    LOG.debugFine((CharSequence)msg.append("\n1 anchor = ").append(a).toString());
                }
                return appr;
            }
            if (!lessThanPre) {
                if (marked.contains(a - 1)) {
                    m_a = (y_a - y_p) / (x_a - x_p);
                    if (y_a == y_p) {
                        m_a = 0.0;
                    }
                    t_a = y_a - m_a * x_a;
                    ApproximationLine appr = new ApproximationLine(k_0, m_a, t_a);
                    if (msg != null) {
                        LOG.debugFine((CharSequence)msg.append("2 anchor = ").append(a).append(" appr1 ").append(appr).append(" x_a ").append(x_a).append(", y_a ").append(y_a).append(" x_p ").append(x_p).append(", y_p ").append(y_p).append(" a ").append(a).append(" upperHull ").append(FormatUtil.format((int[])upperHull)).toString());
                    }
                    return appr;
                }
                --a;
                continue;
            }
            if (marked.contains(a + 1)) {
                m_a = (y_a - y_s) / (x_a - x_s);
                if (y_a == y_p) {
                    m_a = 0.0;
                }
                t_a = y_a - m_a * x_a;
                ApproximationLine appr = new ApproximationLine(k_0, m_a, t_a);
                if (msg != null) {
                    LOG.debugFine((CharSequence)msg.append("3 anchor = ").append(a).append(" -- ").append(a + 1).append(" appr2 ").append(appr).toString());
                }
                return appr;
            }
            ++a;
        }
        return null;
    }

    private ApproximationLine approximateUpperHullOld(ConvexHull convexHull, double[] log_k, double sum_log_k, double sum_log_k2, double[] log_kDist, double sum_log_kDist, double sum_log_k_kDist) {
        StringBuilder msg = new StringBuilder(10000);
        int[] upperHull = convexHull.getUpperHull();
        int u = convexHull.getNumberOfPointsInUpperHull();
        int k_0 = ((MkTreeSettings)this.settings).kmax - upperHull.length + 1;
        msg.append("upper hull:").append(u);
        double upp_error = Double.MAX_VALUE;
        double upp_m = 0.0;
        double upp_t = 0.0;
        for (int i = 1; i < u; ++i) {
            double cur_m = (log_kDist[upperHull[i]] - log_kDist[upperHull[i - 1]]) / (log_k[upperHull[i]] - log_k[upperHull[i - 1]]);
            double cur_t = log_kDist[upperHull[i]] - cur_m * log_k[upperHull[i]];
            double cur_error = this.ssqerr(k_0, ((MkTreeSettings)this.settings).kmax, log_k, log_kDist, cur_m, cur_t);
            if (!(cur_error < upp_error)) continue;
            upp_error = cur_error;
            upp_m = cur_m;
            upp_t = cur_t;
        }
        boolean is_left = true;
        for (int i = 0; i < u; ++i) {
            double cur_error;
            double cur_m = this.optimize(k_0, ((MkTreeSettings)this.settings).kmax, sum_log_k, sum_log_k2, log_k[upperHull[i]], log_kDist[upperHull[i]], sum_log_k_kDist, sum_log_kDist);
            double cur_t = log_kDist[upperHull[i]] - cur_m * log_k[upperHull[i]];
            if ((i == 0 || log_kDist[upperHull[i - 1]] <= log_kDist[upperHull[i]] - cur_m * (log_k[upperHull[i]] - log_k[upperHull[i - 1]])) && (i == u - 1 || log_kDist[upperHull[i + 1]] <= log_kDist[upperHull[i]] + cur_m * (log_k[upperHull[i + 1]] - log_k[upperHull[i]])) && (cur_error = this.ssqerr(k_0, ((MkTreeSettings)this.settings).kmax, log_k, log_kDist, cur_m, cur_t)) < upp_error) {
                upp_error = cur_error;
                upp_m = cur_m;
                upp_t = cur_t;
            }
            if (!(i > 0 && log_kDist[upperHull[i - 1]] > log_kDist[upperHull[i]] - cur_m * (log_k[upperHull[i]] - log_k[upperHull[i - 1]]) || is_left)) {
                LOG.warning((CharSequence)("ERROR upper: The bisection search will not work properly !\n" + FormatUtil.format((double[])log_kDist)));
            }
            if (i < u - 1 && log_kDist[upperHull[i + 1]] > log_kDist[upperHull[i]] + cur_m * (log_k[upperHull[i + 1]] - log_k[upperHull[i]])) continue;
            is_left = false;
        }
        return new ApproximationLine(k_0, upp_m, upp_t);
    }

    protected MkCoPTreeNode<O> createNewLeafNode() {
        return new MkCoPTreeNode(this.leafCapacity, true);
    }

    protected MkCoPTreeNode<O> createNewDirectoryNode() {
        return new MkCoPTreeNode(this.dirCapacity, false);
    }

    @Override
    protected MkCoPEntry createNewDirectoryEntry(MkCoPTreeNode<O> node, DBID routingObjectID, double parentDistance) {
        return new MkCoPDirectoryEntry(routingObjectID, parentDistance, node.getPageID(), node.coveringRadiusFromEntries(routingObjectID, this), null);
    }

    protected MkCoPEntry createRootEntry() {
        return new MkCoPDirectoryEntry(null, 0.0, 0, 0.0, null);
    }

    protected Logging getLogger() {
        return LOG;
    }
}

