/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

import elki.database.relation.Relation;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeFactory;
import elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPTreeIndex;
import elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPTreeNode;
import elki.persistent.PageFile;
import elki.persistent.PageFileFactory;
import elki.utilities.ClassGenericsUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

public class MkCopTreeFactory<O>
extends AbstractMTreeFactory<O, MkCoPTreeNode<O>, MkCoPEntry, MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry>> {
    public MkCopTreeFactory(PageFileFactory<?> pageFileFactory, MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry> settings) {
        super(pageFileFactory, settings);
    }

    public MkCoPTreeIndex<O> instantiate(Relation<O> relation) {
        PageFile pagefile = this.makePageFile(this.getNodeClass());
        return new MkCoPTreeIndex<O>(relation, pagefile, (MkTreeSettings)this.settings);
    }

    protected Class<MkCoPTreeNode<O>> getNodeClass() {
        return ClassGenericsUtil.uglyCastIntoSubclass(MkCoPTreeNode.class);
    }

    public static class Par<O>
    extends AbstractMTreeFactory.Par<O, MkCoPTreeNode<O>, MkCoPEntry, MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry>> {
        public static final OptionID K_ID = new OptionID("mkcop.k", "positive integer specifying the maximum number k of reverse k nearest neighbors to be supported.");

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                ((MkTreeSettings)this.settings).kmax = x;
            });
        }

        @Override
        public MkCopTreeFactory<O> make() {
            return new MkCopTreeFactory(this.pageFileFactory, (MkTreeSettings)this.settings);
        }

        @Override
        protected MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry> makeSettings() {
            return new MkTreeSettings();
        }
    }
}

