/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mkmax;

import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBID;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.relation.Relation;
import elki.index.tree.metrical.mtreevariants.mktrees.AbstractMkTreeUnified;
import elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxDirectoryEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxTreeNode;
import elki.logging.Logging;
import elki.persistent.PageFile;
import elki.utilities.pairs.DoubleIntPair;
import java.util.List;
import java.util.Map;

public abstract class MkMaxTree<O>
extends AbstractMkTreeUnified<O, MkMaxTreeNode<O>, MkMaxEntry, MkTreeSettings<O, MkMaxTreeNode<O>, MkMaxEntry>> {
    private static final Logging LOG = Logging.getLogger(MkMaxTree.class);

    public MkMaxTree(Relation<O> relation, PageFile<MkMaxTreeNode<O>> pagefile, MkTreeSettings<O, MkMaxTreeNode<O>, MkMaxEntry> settings) {
        super(relation, pagefile, settings);
    }

    @Override
    public DoubleDBIDList reverseKNNQuery(DBIDRef id, int k) {
        if (k > this.getKmax()) {
            throw new IllegalArgumentException("Parameter k has to be equal or less than parameter k of the MkMax-Tree!");
        }
        ModifiableDoubleDBIDList candidates = DBIDUtil.newDistanceDBIDList();
        this.doReverseKNNQuery(id, (MkMaxTreeNode)this.getNode(this.getRootID()), null, candidates);
        if (k == this.getKmax()) {
            return candidates.sort();
        }
        ArrayModifiableDBIDs candidateIDs = DBIDUtil.newArray((int)candidates.size());
        DoubleDBIDListMIter candidate = candidates.iter();
        while (candidate.valid()) {
            candidateIDs.add((DBIDRef)candidate);
            candidate.advance();
        }
        Map<DBID, KNNList> knnLists = this.batchNN((MkMaxTreeNode)this.getNode(this.getRootID()), (DBIDs)candidateIDs, k);
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        DBIDMIter iter = candidateIDs.iter();
        while (iter.valid()) {
            DBID cid = DBIDUtil.deref((DBIDRef)iter);
            KNNList cands = knnLists.get(cid);
            DoubleDBIDListIter iter2 = cands.iter();
            while (iter2.valid()) {
                if (DBIDUtil.equal((DBIDRef)id, (DBIDRef)iter2)) {
                    result.add(iter2.doubleValue(), (DBIDRef)cid);
                    break;
                }
                iter2.advance();
            }
            iter.advance();
        }
        result.sort();
        return result;
    }

    protected void preInsert(MkMaxEntry entry) {
        KNNHeap knns_o = DBIDUtil.newHeap((int)this.getKmax());
        this.preInsert(entry, (MkMaxEntry)this.getRootEntry(), knns_o);
    }

    @Override
    protected void kNNdistanceAdjustment(MkMaxEntry entry, Map<DBID, KNNList> knnLists) {
        MkMaxTreeNode node = (MkMaxTreeNode)this.getNode(entry);
        double knnDist_node = 0.0;
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                MkMaxEntry leafEntry = (MkMaxEntry)node.getEntry(i);
                leafEntry.setKnnDistance(knnLists.get(leafEntry.getRoutingObjectID()).getKNNDistance());
                knnDist_node = Math.max(knnDist_node, leafEntry.getKnnDistance());
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                MkMaxEntry dirEntry = (MkMaxEntry)node.getEntry(i);
                this.kNNdistanceAdjustment(dirEntry, knnLists);
                knnDist_node = Math.max(knnDist_node, dirEntry.getKnnDistance());
            }
        }
        entry.setKnnDistance(knnDist_node);
    }

    private void doReverseKNNQuery(DBIDRef q, MkMaxTreeNode<O> node, MkMaxEntry node_entry, ModifiableDoubleDBIDList result) {
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                MkMaxEntry entry = (MkMaxEntry)node.getEntry(i);
                double distance = this.distance((DBIDRef)entry.getRoutingObjectID(), q);
                if (!(distance <= entry.getKnnDistance())) continue;
                result.add(distance, (DBIDRef)entry.getRoutingObjectID());
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                double minDist;
                MkMaxEntry entry = (MkMaxEntry)node.getEntry(i);
                double node_knnDist = node_entry != null ? node_entry.getKnnDistance() : Double.POSITIVE_INFINITY;
                double distance = this.distance((DBIDRef)entry.getRoutingObjectID(), q);
                double d = minDist = entry.getCoveringRadius() > distance ? 0.0 : distance - entry.getCoveringRadius();
                if (!(minDist <= node_knnDist)) continue;
                MkMaxTreeNode childNode = (MkMaxTreeNode)this.getNode(entry);
                this.doReverseKNNQuery(q, childNode, entry, result);
            }
        }
    }

    private void preInsert(MkMaxEntry q, MkMaxEntry nodeEntry, KNNHeap knns_q) {
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)("preInsert " + q + " - " + nodeEntry + "\n"));
        }
        double knnDist_q = knns_q.getKNNDistance();
        MkMaxTreeNode node = (MkMaxTreeNode)this.getNode(nodeEntry);
        double knnDist_node = 0.0;
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                MkMaxEntry p = (MkMaxEntry)node.getEntry(i);
                double dist_pq = this.distance((DBIDRef)p.getRoutingObjectID(), (DBIDRef)q.getRoutingObjectID());
                if (dist_pq <= knnDist_q) {
                    knns_q.insert(dist_pq, (DBIDRef)p.getRoutingObjectID());
                    if (knns_q.size() >= this.getKmax()) {
                        knnDist_q = knns_q.getKNNDistance();
                        q.setKnnDistance(knnDist_q);
                    }
                }
                if (dist_pq <= p.getKnnDistance()) {
                    KNNList knns_p = this.knnq.getKNN((Object)p.getRoutingObjectID(), this.getKmax() - 1);
                    if (knns_p.size() + 1 < this.getKmax()) {
                        p.setKnnDistance(Double.NaN);
                    } else {
                        double knnDist_p = Math.max(dist_pq, knns_p.getKNNDistance());
                        p.setKnnDistance(knnDist_p);
                    }
                }
                knnDist_node = Math.max(knnDist_node, p.getKnnDistance());
            }
        } else {
            List<DoubleIntPair> entries = this.getSortedEntries(node, q.getRoutingObjectID());
            for (DoubleIntPair distEntry : entries) {
                MkMaxEntry dirEntry = (MkMaxEntry)node.getEntry(distEntry.second);
                double entry_knnDist = dirEntry.getKnnDistance();
                if ((double)distEntry.second < entry_knnDist || (double)distEntry.second < knnDist_q) {
                    this.preInsert(q, dirEntry, knns_q);
                    knnDist_q = knns_q.getKNNDistance();
                }
                knnDist_node = Math.max(knnDist_node, dirEntry.getKnnDistance());
            }
        }
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)(nodeEntry + "set knn dist " + knnDist_node));
        }
        nodeEntry.setKnnDistance(knnDist_node);
    }

    protected void initializeCapacities(MkMaxEntry exampleLeaf) {
        int distanceSize = 8;
        double overhead = 12.125;
        if ((double)this.getPageSize() - overhead < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)((double)this.getPageSize() - overhead) / (8 + 3 * distanceSize) + 1;
        if (this.dirCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            LOG.warning((CharSequence)("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1)));
        }
        this.leafCapacity = (int)((double)this.getPageSize() - overhead) / (4 + 2 * distanceSize) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            LOG.warning((CharSequence)("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1)));
        }
    }

    protected MkMaxTreeNode<O> createNewLeafNode() {
        return new MkMaxTreeNode(this.leafCapacity, true);
    }

    protected MkMaxTreeNode<O> createNewDirectoryNode() {
        return new MkMaxTreeNode(this.dirCapacity, false);
    }

    @Override
    protected MkMaxEntry createNewDirectoryEntry(MkMaxTreeNode<O> node, DBID routingObjectID, double parentDistance) {
        return new MkMaxDirectoryEntry(routingObjectID, parentDistance, node.getPageID(), node.coveringRadiusFromEntries(routingObjectID, this), node.kNNDistance());
    }

    protected MkMaxEntry createRootEntry() {
        return new MkMaxDirectoryEntry(null, 0.0, 0, 0.0, 0.0);
    }

    protected Logging getLogger() {
        return LOG;
    }
}

