/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mkmax;

import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.relation.Relation;
import elki.index.DynamicIndex;
import elki.index.KNNIndex;
import elki.index.RKNNIndex;
import elki.index.RangeIndex;
import elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxLeafEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxTree;
import elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxTreeNode;
import elki.index.tree.metrical.mtreevariants.query.MTreeKNNByDBID;
import elki.index.tree.metrical.mtreevariants.query.MTreeKNNByObject;
import elki.index.tree.metrical.mtreevariants.query.MTreeRangeByDBID;
import elki.index.tree.metrical.mtreevariants.query.MTreeRangeByObject;
import elki.index.tree.metrical.mtreevariants.query.MkTreeRKNNQuery;
import elki.persistent.PageFile;
import elki.utilities.exceptions.NotImplementedException;
import java.util.ArrayList;

public class MkMaxTreeIndex<O>
extends MkMaxTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
RKNNIndex<O>,
DynamicIndex {
    private Relation<O> relation;

    public MkMaxTreeIndex(Relation<O> relation, PageFile<MkMaxTreeNode<O>> pagefile, MkTreeSettings<O, MkMaxTreeNode<O>, MkMaxEntry> settings) {
        super(relation, pagefile, settings);
        this.relation = relation;
    }

    protected MkMaxLeafEntry createNewLeafEntry(DBID id, DBIDRef object, double parentDistance) {
        KNNList knns = this.knnq.getKNN((Object)object, this.getKmax() - 1);
        double knnDistance = knns.getKNNDistance();
        return new MkMaxLeafEntry(id, parentDistance, knnDistance);
    }

    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    public void insert(DBIDRef id) {
        this.insert(this.createNewLeafEntry(DBIDUtil.deref((DBIDRef)id), id, Double.NaN), false);
    }

    public void insertAll(DBIDs ids) {
        ArrayList<MkMaxLeafEntry> objs = new ArrayList<MkMaxLeafEntry>(ids.size());
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref((DBIDRef)iter);
            objs.add(this.createNewLeafEntry(id, (DBIDRef)id, Double.NaN));
            iter.advance();
        }
        this.insertAll(objs);
    }

    public final boolean delete(DBIDRef id) {
        throw new NotImplementedException();
    }

    public void deleteAll(DBIDs ids) {
        throw new NotImplementedException();
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeKNNByObject<O>(this, distanceQuery) : null;
    }

    public KNNSearcher<DBIDRef> kNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeKNNByDBID<O>(this, distanceQuery) : null;
    }

    public RangeSearcher<O> rangeByObject(DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeRangeByObject<O>(this, distanceQuery) : null;
    }

    public RangeSearcher<DBIDRef> rangeByDBID(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeRangeByDBID<O>(this, distanceQuery) : null;
    }

    public RKNNSearcher<O> rkNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    public RKNNSearcher<DBIDRef> rkNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MkTreeRKNNQuery<O>(this, distanceQuery) : null;
    }
}

