/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mkmax;

import elki.database.ids.DBID;
import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxEntry;

class MkMaxTreeNode<O>
extends AbstractMTreeNode<O, MkMaxTreeNode<O>, MkMaxEntry> {
    private static final long serialVersionUID = 1L;

    public MkMaxTreeNode() {
    }

    public MkMaxTreeNode(int capacity, boolean isLeaf) {
        super(capacity, isLeaf);
    }

    protected double kNNDistance() {
        double knnDist = 0.0;
        for (int i = 0; i < this.getNumEntries(); ++i) {
            MkMaxEntry entry = (MkMaxEntry)this.getEntry(i);
            knnDist = Math.max(knnDist, entry.getKnnDistance());
        }
        return knnDist;
    }

    @Override
    public boolean adjustEntry(MkMaxEntry entry, DBID routingObjectID, double parentDistance, AbstractMTree<O, MkMaxTreeNode<O>, MkMaxEntry, ?> mTree) {
        super.adjustEntry(entry, routingObjectID, parentDistance, mTree);
        entry.setKnnDistance(this.kNNDistance());
        return true;
    }

    @Override
    protected void integrityCheckParameters(MkMaxEntry parentEntry, MkMaxTreeNode<O> parent, int index, AbstractMTree<O, MkMaxTreeNode<O>, MkMaxEntry, ?> mTree) {
        super.integrityCheckParameters(parentEntry, parent, index, mTree);
        MkMaxEntry entry = (MkMaxEntry)parent.getEntry(index);
        double knnDistance = this.kNNDistance();
        if (Math.abs(entry.getKnnDistance() - knnDistance) > 0.0) {
            throw new RuntimeException("Wrong knnDistance in node " + parent.getPageID() + " at index " + index + " (child " + entry + ")\nsoll: " + knnDistance + ",\n ist: " + entry.getKnnDistance());
        }
    }
}

