/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mktab;

import elki.database.ids.DBID;
import elki.index.tree.metrical.mtreevariants.MTreeDirectoryEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class MkTabDirectoryEntry
extends MTreeDirectoryEntry
implements MkTabEntry {
    private static final long serialVersionUID = 2L;
    private double[] knnDistances;

    public MkTabDirectoryEntry() {
    }

    public MkTabDirectoryEntry(DBID objectID, double parentDistance, int nodeID, double coveringRadius, double[] knnDistances) {
        super(objectID, parentDistance, nodeID, coveringRadius);
        this.knnDistances = knnDistances;
    }

    @Override
    public double[] getKnnDistances() {
        return this.knnDistances;
    }

    @Override
    public void setKnnDistances(double[] knnDistances) {
        this.knnDistances = knnDistances;
    }

    @Override
    public double getKnnDistance(int k) {
        if (k >= this.knnDistances.length) {
            throw new IllegalArgumentException("Parameter k = " + k + " is not supported!");
        }
        return this.knnDistances[k - 1];
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        int k_max = this.knnDistances.length;
        out.writeInt(k_max);
        for (int i = 0; i < k_max; ++i) {
            out.writeDouble(this.knnDistances[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int k_max = in.readInt();
        this.knnDistances = new double[k_max];
        for (int i = 0; i < k_max; ++i) {
            this.knnDistances[i] = in.readDouble();
        }
    }
}

