/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mktab;

import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.relation.Relation;
import elki.index.tree.metrical.mtreevariants.mktrees.AbstractMkTreeUnified;
import elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabDirectoryEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabLeafEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabTreeNode;
import elki.logging.Logging;
import elki.persistent.PageFile;
import java.util.Map;

public abstract class MkTabTree<O>
extends AbstractMkTreeUnified<O, MkTabTreeNode<O>, MkTabEntry, MkTreeSettings<O, MkTabTreeNode<O>, MkTabEntry>> {
    private static final Logging LOG = Logging.getLogger(MkTabTree.class);

    public MkTabTree(Relation<O> relation, PageFile<MkTabTreeNode<O>> pagefile, MkTreeSettings<O, MkTabTreeNode<O>, MkTabEntry> settings) {
        super(relation, pagefile, settings);
    }

    protected void preInsert(MkTabEntry entry) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    public void insert(MkTabEntry entry, boolean withPreInsert) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    public DoubleDBIDList reverseKNNQuery(DBIDRef id, int k) {
        if (k > this.getKmax()) {
            throw new IllegalArgumentException("Parameter k has to be less or equal than parameter kmax of the MkTab-Tree!");
        }
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        this.doReverseKNNQuery(k, id, null, (MkTabTreeNode)this.getNode(this.getRootID()), result);
        return result.sort();
    }

    protected void initializeCapacities(MkTabEntry exampleLeaf) {
        int distanceSize = 8;
        double overhead = 12.125;
        if ((double)this.getPageSize() - overhead < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)((double)this.getPageSize() - overhead) / (8 + distanceSize + distanceSize + 4 + this.getKmax() * distanceSize) + 1;
        if (this.dirCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            LOG.warning((CharSequence)("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1)));
        }
        this.leafCapacity = (int)((double)this.getPageSize() - overhead) / (4 + distanceSize + 4 + this.getKmax() * distanceSize) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            LOG.warning((CharSequence)("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1)));
        }
    }

    @Override
    protected void kNNdistanceAdjustment(MkTabEntry entry, Map<DBID, KNNList> knnLists) {
        MkTabTreeNode node = (MkTabTreeNode)this.getNode(entry);
        double[] knnDistances_node = this.initKnnDistanceList();
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                MkTabLeafEntry leafEntry = (MkTabLeafEntry)node.getEntry(i);
                KNNList knns = knnLists.get(leafEntry.getDBID());
                double[] distances = new double[knns.size()];
                int j = 0;
                DoubleDBIDListIter iter = knns.iter();
                while (iter.valid()) {
                    distances[j] = iter.doubleValue();
                    iter.advance();
                    ++j;
                }
                leafEntry.setKnnDistances(distances);
                knnDistances_node = this.max(knnDistances_node, leafEntry.getKnnDistances());
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                MkTabEntry dirEntry = (MkTabEntry)node.getEntry(i);
                this.kNNdistanceAdjustment(dirEntry, knnLists);
                knnDistances_node = this.max(knnDistances_node, dirEntry.getKnnDistances());
            }
        }
        entry.setKnnDistances(knnDistances_node);
    }

    protected MkTabTreeNode<O> createNewLeafNode() {
        return new MkTabTreeNode(this.leafCapacity, true);
    }

    protected MkTabTreeNode<O> createNewDirectoryNode() {
        return new MkTabTreeNode(this.dirCapacity, false);
    }

    @Override
    protected MkTabEntry createNewDirectoryEntry(MkTabTreeNode<O> node, DBID routingObjectID, double parentDistance) {
        return new MkTabDirectoryEntry(routingObjectID, parentDistance, node.getPageID(), node.coveringRadiusFromEntries(routingObjectID, this), node.kNNDistances());
    }

    protected MkTabEntry createRootEntry() {
        return new MkTabDirectoryEntry(null, 0.0, 0, 0.0, this.initKnnDistanceList());
    }

    private void doReverseKNNQuery(int k, DBIDRef q, MkTabEntry node_entry, MkTabTreeNode<O> node, ModifiableDoubleDBIDList result) {
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                MkTabEntry entry = (MkTabEntry)node.getEntry(i);
                double distance = this.distance((DBIDRef)entry.getRoutingObjectID(), q);
                if (!(distance <= entry.getKnnDistance(k))) continue;
                result.add(distance, (DBIDRef)entry.getRoutingObjectID());
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                double minDist;
                MkTabEntry entry = (MkTabEntry)node.getEntry(i);
                double node_knnDist = node_entry != null ? node_entry.getKnnDistance(k) : Double.POSITIVE_INFINITY;
                double distance = this.distance((DBIDRef)entry.getRoutingObjectID(), q);
                double d = minDist = entry.getCoveringRadius() > distance ? 0.0 : distance - entry.getCoveringRadius();
                if (!(minDist <= node_knnDist)) continue;
                MkTabTreeNode childNode = (MkTabTreeNode)this.getNode(entry);
                this.doReverseKNNQuery(k, q, entry, childNode, result);
            }
        }
    }

    private double[] max(double[] distances1, double[] distances2) {
        if (distances1.length != distances2.length) {
            throw new RuntimeException("different lengths!");
        }
        double[] result = new double[distances1.length];
        for (int i = 0; i < distances1.length; ++i) {
            result[i] = Math.max(distances1[i], distances2[i]);
        }
        return result;
    }

    private double[] initKnnDistanceList() {
        double[] knnDistances = new double[this.getKmax()];
        return knnDistances;
    }

    protected Logging getLogger() {
        return LOG;
    }
}

