/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mktab;

import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.relation.Relation;
import elki.index.KNNIndex;
import elki.index.RKNNIndex;
import elki.index.RangeIndex;
import elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabLeafEntry;
import elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabTree;
import elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabTreeNode;
import elki.index.tree.metrical.mtreevariants.query.MTreeKNNByDBID;
import elki.index.tree.metrical.mtreevariants.query.MTreeKNNByObject;
import elki.index.tree.metrical.mtreevariants.query.MTreeRangeByDBID;
import elki.index.tree.metrical.mtreevariants.query.MTreeRangeByObject;
import elki.index.tree.metrical.mtreevariants.query.MkTreeRKNNQuery;
import elki.persistent.PageFile;
import java.util.ArrayList;

public class MkTabTreeIndex<O>
extends MkTabTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
RKNNIndex<O> {
    private Relation<O> relation;

    public MkTabTreeIndex(Relation<O> relation, PageFile<MkTabTreeNode<O>> pagefile, MkTreeSettings<O, MkTabTreeNode<O>, MkTabEntry> settings) {
        super(relation, pagefile, settings);
        this.relation = relation;
    }

    protected MkTabEntry createNewLeafEntry(DBID id, DBIDRef object, double parentDistance) {
        return new MkTabLeafEntry(id, parentDistance, this.knnDistances(object));
    }

    private double[] knnDistances(DBIDRef object) {
        KNNList knns = this.knnq.getKNN((Object)object, this.getKmax() - 1);
        double[] distances = new double[this.getKmax()];
        DoubleDBIDListIter iter = knns.iter();
        for (int i = 0; iter.valid() && i < this.getKmax(); ++i) {
            distances[i] = iter.doubleValue();
            iter.advance();
        }
        return distances;
    }

    public void initialize() {
        super.initialize();
        ArrayList<MkTabEntry> objs = new ArrayList<MkTabEntry>(this.relation.size());
        DBIDIter iter = this.relation.iterDBIDs();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref((DBIDRef)iter);
            objs.add(this.createNewLeafEntry(id, (DBIDRef)id, Double.NaN));
            iter.advance();
        }
        this.insertAll(objs);
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeKNNByObject<O>(this, distanceQuery) : null;
    }

    public KNNSearcher<DBIDRef> kNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeKNNByDBID<O>(this, distanceQuery) : null;
    }

    public RangeSearcher<O> rangeByObject(DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeRangeByObject<O>(this, distanceQuery) : null;
    }

    public RangeSearcher<DBIDRef> rangeByDBID(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeRangeByDBID<O>(this, distanceQuery) : null;
    }

    public RKNNSearcher<O> rkNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    public RKNNSearcher<DBIDRef> rkNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MkTreeRKNNQuery<O>(this, distanceQuery) : null;
    }
}

