/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mktrees.mktab;

import elki.database.ids.DBID;
import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabEntry;
import java.util.Arrays;

class MkTabTreeNode<O>
extends AbstractMTreeNode<O, MkTabTreeNode<O>, MkTabEntry> {
    private static final long serialVersionUID = 2L;

    public MkTabTreeNode() {
    }

    public MkTabTreeNode(int capacity, boolean isLeaf) {
        super(capacity, isLeaf);
    }

    protected double[] kNNDistances() {
        int k = ((MkTabEntry)this.getEntry(0)).getKnnDistances().length;
        double[] result = new double[k];
        for (int i = 0; i < this.getNumEntries(); ++i) {
            for (int j = 0; j < k; ++j) {
                MkTabEntry entry = (MkTabEntry)this.getEntry(i);
                result[j] = Math.max(result[j], entry.getKnnDistance(j + 1));
            }
        }
        return result;
    }

    @Override
    public boolean adjustEntry(MkTabEntry entry, DBID routingObjectID, double parentDistance, AbstractMTree<O, MkTabTreeNode<O>, MkTabEntry, ?> mTree) {
        super.adjustEntry(entry, routingObjectID, parentDistance, mTree);
        entry.setKnnDistances(this.kNNDistances());
        return true;
    }

    @Override
    protected void integrityCheckParameters(MkTabEntry parentEntry, MkTabTreeNode<O> parent, int index, AbstractMTree<O, MkTabTreeNode<O>, MkTabEntry, ?> mTree) {
        super.integrityCheckParameters(parentEntry, parent, index, mTree);
        MkTabEntry entry = (MkTabEntry)parent.getEntry(index);
        double[] knnDistances = this.kNNDistances();
        if (!Arrays.equals(entry.getKnnDistances(), knnDistances)) {
            String soll = knnDistances.toString();
            String ist = entry.getKnnDistances().toString();
            throw new RuntimeException("Wrong knnDistances in node " + parent.getPageID() + " at index " + index + " (child " + entry + ")\nsoll: " + soll + ",\n ist: " + ist);
        }
    }
}

