/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mtree;

import elki.database.ids.DBID;
import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.MTreeDirectoryEntry;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.MTreeSettings;
import elki.index.tree.metrical.mtreevariants.mtree.MTreeNode;
import elki.logging.Logging;
import elki.persistent.PageFile;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;

@Title(value="M-Tree")
@Description(value="Efficient Access Method for Similarity Search in Metric Spaces")
@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="Proc. Int. Conf. Very Large Data Bases (VLDB'97)", url="http://www.vldb.org/conf/1997/P426.PDF", bibkey="DBLP:conf/vldb/CiacciaPZ97")
public abstract class MTree<O>
extends AbstractMTree<O, MTreeNode<O>, MTreeEntry, MTreeSettings<O, MTreeNode<O>, MTreeEntry>> {
    private static final Logging LOG = Logging.getLogger(MTree.class);

    public MTree(PageFile<MTreeNode<O>> pagefile, MTreeSettings<O, MTreeNode<O>, MTreeEntry> settings) {
        super(pagefile, settings);
    }

    protected void preInsert(MTreeEntry entry) {
    }

    @Override
    protected MTreeEntry createNewDirectoryEntry(MTreeNode<O> node, DBID routingObjectID, double parentDistance) {
        return new MTreeDirectoryEntry(routingObjectID, parentDistance, node.getPageID(), node.coveringRadiusFromEntries(routingObjectID, this));
    }

    protected MTreeEntry createRootEntry() {
        return new MTreeDirectoryEntry(null, 0.0, 0, 0.0);
    }

    protected MTreeNode<O> createNewLeafNode() {
        return new MTreeNode(this.leafCapacity, true);
    }

    protected MTreeNode<O> createNewDirectoryNode() {
        return new MTreeNode(this.dirCapacity, false);
    }

    protected Logging getLogger() {
        return LOG;
    }
}

