/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.mtree;

import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.index.DynamicIndex;
import elki.index.KNNIndex;
import elki.index.RangeIndex;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.MTreeLeafEntry;
import elki.index.tree.metrical.mtreevariants.MTreeSettings;
import elki.index.tree.metrical.mtreevariants.mtree.MTree;
import elki.index.tree.metrical.mtreevariants.mtree.MTreeNode;
import elki.index.tree.metrical.mtreevariants.query.MTreeKNNByDBID;
import elki.index.tree.metrical.mtreevariants.query.MTreeKNNByObject;
import elki.index.tree.metrical.mtreevariants.query.MTreeRangeByDBID;
import elki.index.tree.metrical.mtreevariants.query.MTreeRangeByObject;
import elki.persistent.PageFile;
import elki.utilities.exceptions.NotImplementedException;
import java.util.ArrayList;

public class MTreeIndex<O>
extends MTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
DynamicIndex {
    private Relation<O> relation;
    protected DistanceQuery<O> distanceQuery;

    public MTreeIndex(Relation<O> relation, PageFile<MTreeNode<O>> pagefile, MTreeSettings<O, MTreeNode<O>, MTreeEntry> settings) {
        super(pagefile, settings);
        this.relation = relation;
        this.distanceQuery = this.getDistance().instantiate(relation);
    }

    @Override
    public double distance(DBIDRef id1, DBIDRef id2) {
        if (id1 == null || id2 == null) {
            return Double.NaN;
        }
        if (DBIDUtil.equal((DBIDRef)id1, (DBIDRef)id2)) {
            return 0.0;
        }
        this.statistics.countDistanceCalculation();
        return this.distanceQuery.distance(id1, id2);
    }

    protected void initializeCapacities(MTreeEntry exampleLeaf) {
        int distanceSize = 8;
        Relation<O> vrel = this.relation;
        int dim = RelationUtil.dimensionality(vrel);
        int featuresize = 8 * dim;
        if (dim <= 0) {
            this.getLogger().warning((CharSequence)"Relation does not have a dimensionality -- simulating M-tree as external index!");
            featuresize = 0;
        }
        double overhead = 12.125;
        if ((double)this.getPageSize() - overhead < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)((double)this.getPageSize() - overhead) / (4 + featuresize + distanceSize + distanceSize) + 1;
        if (this.dirCapacity <= 2) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            this.getLogger().warning((CharSequence)("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1)));
        }
        this.leafCapacity = (int)((double)this.getPageSize() - overhead) / (4 + featuresize + distanceSize) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            this.getLogger().warning((CharSequence)("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1)));
        }
    }

    protected MTreeEntry createNewLeafEntry(DBID id, O object, double parentDistance) {
        return new MTreeLeafEntry(id, parentDistance);
    }

    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    public void insert(DBIDRef id) {
        this.insert(this.createNewLeafEntry(DBIDUtil.deref((DBIDRef)id), this.relation.get(id), Double.NaN), false);
    }

    public void insertAll(DBIDs ids) {
        ArrayList<MTreeEntry> objs = new ArrayList<MTreeEntry>(ids.size());
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref((DBIDRef)iter);
            Object object = this.relation.get((DBIDRef)id);
            objs.add(this.createNewLeafEntry(id, object, Double.NaN));
            iter.advance();
        }
        this.insertAll(objs);
    }

    public final boolean delete(DBIDRef id) {
        throw new NotImplementedException();
    }

    public void deleteAll(DBIDs ids) {
        throw new NotImplementedException();
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeKNNByObject<O>(this, distanceQuery) : null;
    }

    public KNNSearcher<DBIDRef> kNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeKNNByDBID<O>(this, distanceQuery) : null;
    }

    public RangeSearcher<O> rangeByObject(DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeRangeByObject<O>(this, distanceQuery) : null;
    }

    public RangeSearcher<DBIDRef> rangeByDBID(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return (flags & 0x20) == 0 && distanceQuery.getRelation() == this.relation && this.getDistance().equals(distanceQuery.getDistance()) ? new MTreeRangeByDBID<O>(this, distanceQuery) : null;
    }
}

