/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.query;

import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.index.tree.DirectoryEntry;
import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.query.MTreeSearchCandidate;
import elki.utilities.datastructures.heap.ComparableMinHeap;

public class MTreeKNNByDBID<O>
implements KNNSearcher<DBIDRef> {
    protected final AbstractMTree<O, ?, ?, ?> index;
    protected final DistanceQuery<O> distanceQuery;

    public MTreeKNNByDBID(AbstractMTree<O, ?, ?, ?> index, DistanceQuery<O> distanceQuery) {
        this.index = index;
        this.distanceQuery = distanceQuery;
    }

    public KNNList getKNN(DBIDRef q, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("At least one object has to be requested!");
        }
        this.index.statistics.countKNNQuery();
        KNNHeap knnList = DBIDUtil.newHeap((int)k);
        double d_k = Double.POSITIVE_INFINITY;
        ComparableMinHeap pq = new ComparableMinHeap();
        pq.add((Comparable)new MTreeSearchCandidate(0.0, this.index.getRootID(), null, 0.0));
        while (!pq.isEmpty()) {
            MTreeEntry entry;
            int i;
            MTreeSearchCandidate pqNode = (MTreeSearchCandidate)pq.poll();
            if (knnList.size() >= k && pqNode.mindist > d_k) break;
            AbstractMTreeNode node = (AbstractMTreeNode)this.index.getNode(pqNode.nodeID);
            DBID id_p = pqNode.routingObjectID;
            double d1 = pqNode.routingDistance;
            if (!node.isLeaf()) {
                for (i = 0; i < node.getNumEntries(); ++i) {
                    double d2;
                    entry = (MTreeEntry)node.getEntry(i);
                    double r_or = entry.getCoveringRadius();
                    double d = d2 = id_p != null ? entry.getParentDistance() : 0.0;
                    if (!(Math.abs(d1 - d2) <= d_k + r_or)) continue;
                    DBID o_r = entry.getRoutingObjectID();
                    double d3 = this.distanceQuery.distance((DBIDRef)o_r, q);
                    this.index.statistics.countDistanceCalculation();
                    double d_min = Math.max(d3 - r_or, 0.0);
                    if (!(d_min <= d_k)) continue;
                    pq.add((Comparable)new MTreeSearchCandidate(d_min, ((DirectoryEntry)entry).getPageID(), o_r, d3));
                }
                continue;
            }
            for (i = 0; i < node.getNumEntries(); ++i) {
                double d2;
                entry = (MTreeEntry)node.getEntry(i);
                double d = d2 = id_p != null ? entry.getParentDistance() : 0.0;
                if (!(Math.abs(d1 - d2) <= d_k)) continue;
                DBID o_j = entry.getRoutingObjectID();
                double d3 = this.distanceQuery.distance((DBIDRef)o_j, q);
                this.index.statistics.countDistanceCalculation();
                if (!(d3 <= d_k)) continue;
                knnList.insert(d3, (DBIDRef)o_j);
                d_k = knnList.getKNNDistance();
            }
        }
        return knnList.toKNNList();
    }
}

