/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.query;

import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.range.RangeSearcher;
import elki.index.tree.DirectoryEntry;
import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;

public class MTreeRangeByObject<O>
implements RangeSearcher<O> {
    protected final AbstractMTree<O, ?, ?, ?> index;
    protected final DistanceQuery<O> distanceQuery;

    public MTreeRangeByObject(AbstractMTree<O, ?, ?, ?> index, DistanceQuery<O> distanceQuery) {
        this.index = index;
        this.distanceQuery = distanceQuery;
    }

    private void doRangeQuery(DBID o_p, AbstractMTreeNode<O, ?, ?> node, O q, double r_q, ModifiableDoubleDBIDList result) {
        double d1 = 0.0;
        if (o_p != null) {
            d1 = this.distanceQuery.distance((DBIDRef)o_p, q);
            this.index.statistics.countDistanceCalculation();
        }
        if (!node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                MTreeEntry entry = (MTreeEntry)node.getEntry(i);
                double d2 = o_p != null ? entry.getParentDistance() : 0.0;
                double sum = r_q + entry.getCoveringRadius();
                if (!(Math.abs(d1 - d2) <= sum)) continue;
                this.index.statistics.countDistanceCalculation();
                DBID o_r = entry.getRoutingObjectID();
                if (!(this.distanceQuery.distance((DBIDRef)o_r, q) <= sum)) continue;
                this.doRangeQuery(o_r, (AbstractMTreeNode)this.index.getNode(((DirectoryEntry)entry).getPageID()), q, r_q, result);
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                double d2;
                MTreeEntry entry = (MTreeEntry)node.getEntry(i);
                double d = d2 = o_p != null ? entry.getParentDistance() : 0.0;
                if (!(Math.abs(d1 - d2) <= r_q)) continue;
                DBID o_j = entry.getRoutingObjectID();
                double d3 = this.distanceQuery.distance((DBIDRef)o_j, q);
                this.index.statistics.countDistanceCalculation();
                if (!(d3 <= r_q)) continue;
                result.add(d3, (DBIDRef)o_j);
            }
        }
    }

    public ModifiableDoubleDBIDList getRange(O obj, double range, ModifiableDoubleDBIDList result) {
        this.index.statistics.countRangeQuery();
        this.doRangeQuery(null, (AbstractMTreeNode)this.index.getNode(this.index.getRootID()), obj, range, result);
        return result;
    }
}

