/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.strategies.split;

import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.strategies.split.MTreeSplit;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.GeneralizedHyperplaneDistribution;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractMTreeSplit<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
implements MTreeSplit<E, N> {
    protected DistributionStrategy distributor;

    public AbstractMTreeSplit(DistributionStrategy distributor) {
        this.distributor = distributor;
    }

    protected static <E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>> double[][] computeDistanceMatrix(AbstractMTree<?, N, E, ?> tree, N node) {
        int n = node.getNumEntries();
        double[][] distancematrix = new double[n][n];
        for (int i = 0; i < n; ++i) {
            MTreeEntry ei = (MTreeEntry)node.getEntry(i);
            double[] row_i = distancematrix[i];
            for (int j = i + 1; j < n; ++j) {
                double d = tree.distance(ei, (MTreeEntry)node.getEntry(j));
                distancematrix[j][i] = d;
                row_i[j] = d;
            }
        }
        return distancematrix;
    }

    public static abstract class Par<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
    implements Parameterizer {
        public static final OptionID DISTRIBUTOR_ID = new OptionID("mtree.split.distributor", "Distribution strategy for mtree entries during splitting.");
        protected DistributionStrategy distributor;

        public void configure(Parameterization config) {
            new ObjectParameter(DISTRIBUTOR_ID, DistributionStrategy.class, GeneralizedHyperplaneDistribution.class).grab(config, x -> {
                this.distributor = x;
            });
        }

        public abstract MTreeSplit<E, N> make();
    }
}

