/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.strategies.split;

import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.strategies.split.AbstractMTreeSplit;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;

public class FarthestPointsSplit<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
extends AbstractMTreeSplit<E, N> {
    public FarthestPointsSplit(DistributionStrategy distributor) {
        super(distributor);
    }

    @Override
    public Assignments<E> split(AbstractMTree<?, N, E, ?> tree, N node) {
        int n = node.getNumEntries();
        double[][] distanceMatrix = FarthestPointsSplit.computeDistanceMatrix(tree, node);
        int besti = -1;
        int bestj = -1;
        double currentMaxDist = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double[] row_i = distanceMatrix[i];
            for (int j = i + 1; j < n; ++j) {
                double distance = row_i[j];
                if (!(distance > currentMaxDist)) continue;
                besti = i;
                bestj = j;
                currentMaxDist = distance;
            }
        }
        return this.distributor.distribute(node, besti, distanceMatrix[besti], bestj, distanceMatrix[bestj]);
    }

    public static class Par<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
    extends AbstractMTreeSplit.Par<E, N> {
        @Override
        public FarthestPointsSplit<E, N> make() {
            return new FarthestPointsSplit(this.distributor);
        }
    }
}

