/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.strategies.split;

import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.strategies.split.AbstractMTreeSplit;
import elki.index.tree.metrical.mtreevariants.strategies.split.FarthestPointsSplit;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;

@Priority(value=200)
@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="Proc. Int. Conf. Very Large Data Bases (VLDB'97)", url="http://www.vldb.org/conf/1997/P426.PDF", bibkey="DBLP:conf/vldb/CiacciaPZ97")
public class MLBDistSplit<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
extends AbstractMTreeSplit<E, N> {
    public MLBDistSplit(DistributionStrategy distributor) {
        super(distributor);
    }

    @Override
    public Assignments<E> split(AbstractMTree<?, N, E, ?> tree, N node) {
        double dist1;
        int n = node.getNumEntries();
        int b1 = 0;
        int b2 = 0;
        double dist2 = dist1 = ((MTreeEntry)node.getEntry(0)).getParentDistance();
        if (Double.isNaN(dist1)) {
            return new FarthestPointsSplit<MTreeEntry, N>(this.distributor).split(tree, node);
        }
        for (int i = 1; i < n; ++i) {
            double dist = ((MTreeEntry)node.getEntry(i)).getParentDistance();
            if (dist < dist1) {
                dist1 = dist;
                b1 = i;
                continue;
            }
            if (!(dist > dist2) && (dist != dist2 || i != 1)) continue;
            dist2 = dist;
            b2 = i;
        }
        MTreeEntry e1 = (MTreeEntry)node.getEntry(b1);
        MTreeEntry e2 = (MTreeEntry)node.getEntry(b2);
        double[] rowi = new double[n];
        double[] rowj = new double[n];
        for (int i = 0; i < n; ++i) {
            if (i == b1 || i == b2) continue;
            MTreeEntry ei = (MTreeEntry)node.getEntry(i);
            rowi[i] = tree.distance(e1, ei);
            rowj[i] = tree.distance(e2, ei);
        }
        return this.distributor.distribute(node, b1, rowi, b2, rowj);
    }

    public static class Par<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
    extends AbstractMTreeSplit.Par<E, N> {
        @Override
        public MLBDistSplit<E, N> make() {
            return new MLBDistSplit(this.distributor);
        }
    }
}

