/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.strategies.split;

import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.strategies.split.AbstractMTreeSplit;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;
import elki.utilities.documentation.Reference;

@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="Proc. Int. Conf. Very Large Data Bases (VLDB'97)", url="http://www.vldb.org/conf/1997/P426.PDF", bibkey="DBLP:conf/vldb/CiacciaPZ97")
public class MMRadSplit<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
extends AbstractMTreeSplit<E, N> {
    public MMRadSplit(DistributionStrategy distributor) {
        super(distributor);
    }

    @Override
    public Assignments<E> split(AbstractMTree<?, N, E, ?> tree, N node) {
        int n = node.getNumEntries();
        double[][] distanceMatrix = MMRadSplit.computeDistanceMatrix(tree, node);
        double miSumCR = Double.POSITIVE_INFINITY;
        boolean leaf = node.isLeaf();
        Assignments bestAssignment = null;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                Assignments currentAssignments = this.distributor.distribute(node, i, distanceMatrix[i], j, distanceMatrix[j]);
                double maxCR = Math.max(currentAssignments.computeFirstCover(leaf), currentAssignments.computeSecondCover(leaf));
                if (!(maxCR < miSumCR)) continue;
                miSumCR = maxCR;
                bestAssignment = currentAssignments;
            }
        }
        return bestAssignment;
    }

    public static class Par<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
    extends AbstractMTreeSplit.Par<E, N> {
        @Override
        public MMRadSplit<E, N> make() {
            return new MMRadSplit(this.distributor);
        }
    }
}

