/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.strategies.split;

import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.strategies.split.AbstractMTreeSplit;
import elki.index.tree.metrical.mtreevariants.strategies.split.MTreeSplit;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import elki.math.geometry.PrimsMinimumSpanningTree;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import java.util.Arrays;

@Priority(value=200)
@Reference(authors="C. Traina Jr., A. J. M. Traina, B. Seeger, C. Faloutsos", title="Slim-Trees: High Performance Metric Trees Minimizing Overlap Between Nodes", booktitle="Int. Conf. Extending Database Technology (EDBT'2000)", url="https://doi.org/10.1007/3-540-46439-5_4", bibkey="DBLP:conf/edbt/TrainaTSF00")
public class MSTSplit<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
implements MTreeSplit<E, N> {
    @Override
    public Assignments<E> split(AbstractMTree<?, N, E, ?> tree, N node) {
        double[][] matrix = AbstractMTreeSplit.computeDistanceMatrix(tree, node);
        int[] idx = MSTSplit.mstPartition(matrix);
        assert (idx[0] == 0) : "First partition should have been merged into object 0.";
        int r1 = 0;
        int r2 = 1;
        double m1 = Double.POSITIVE_INFINITY;
        double m2 = Double.POSITIVE_INFINITY;
        int n = node.getNumEntries();
        for (int i = 0; i < n; ++i) {
            double m = MSTSplit.coverRadius(matrix, idx, i);
            if (idx[i] == 0) {
                if (!(m < m1)) continue;
                m1 = m;
                r1 = i;
                continue;
            }
            if (!(m < m2)) continue;
            m2 = m;
            r2 = i;
        }
        Assignments<MTreeEntry> assign = new Assignments<MTreeEntry>(((MTreeEntry)node.getEntry(r1)).getRoutingObjectID(), ((MTreeEntry)node.getEntry(r2)).getRoutingObjectID(), n - 1);
        double[] row1 = matrix[r1];
        double[] row2 = matrix[r2];
        for (int i = 0; i < n; ++i) {
            MTreeEntry ent = (MTreeEntry)node.getEntry(i);
            if (idx[i] == 0) {
                assign.addToFirst(ent, row1[i]);
                continue;
            }
            assert (idx[i] == idx[r2]) : "More than two partitions?";
            assign.addToSecond(ent, row2[i]);
        }
        return assign;
    }

    private static double coverRadius(double[][] matrix, int[] idx, int i) {
        int idx_i = idx[i];
        double[] row_i = matrix[i];
        double m = 0.0;
        for (int j = 0; j < row_i.length; ++j) {
            if (i == j || idx_i != idx[j]) continue;
            double d = row_i[j];
            m = d > m ? d : m;
        }
        return m;
    }

    private static int[] mstPartition(double[][] matrix) {
        int n = matrix.length;
        int[] edges = PrimsMinimumSpanningTree.processDense((double[][])matrix);
        double meanlength = MSTSplit.thresholdLength(matrix, edges);
        int[] idx = new int[n];
        int[] best = new int[n];
        int[] sizes = new int[n];
        int bestsize = -1;
        double bestlen = 0.0;
        for (int omit = n - 2; omit > 0; --omit) {
            double len = MSTSplit.edgelength(matrix, edges, omit);
            if (len < meanlength) continue;
            MSTSplit.omitEdge(edges, idx, sizes, omit);
            int minsize = n;
            for (int i = 0; i < n; ++i) {
                idx[i] = MSTSplit.follow(i, idx);
                int j = idx[i];
                if (j != i || sizes[i] >= minsize) continue;
                minsize = sizes[i];
            }
            if (minsize <= bestsize && (minsize != bestsize || !(len > bestlen))) continue;
            bestsize = minsize;
            bestlen = len;
            System.arraycopy(idx, 0, best, 0, n);
        }
        return best;
    }

    private static double thresholdLength(double[][] matrix, int[] edges) {
        double[] lengths = new double[edges.length >> 1];
        int e = edges.length - 1;
        for (int i = 0; i < e; i += 2) {
            lengths[i >> 1] = matrix[edges[i]][edges[i + 1]];
        }
        Arrays.sort(lengths);
        int pos = lengths.length >> 1;
        return lengths[pos];
    }

    private static double edgelength(double[][] matrix, int[] edges, int i) {
        return matrix[edges[i]][edges[(i <<= 1) + 1]];
    }

    private static void omitEdge(int[] edges, int[] idx, int[] sizes, int omit) {
        int i;
        for (i = 0; i < idx.length; ++i) {
            idx[i] = i;
        }
        Arrays.fill(sizes, 1);
        i = 0;
        int e = edges.length - 1;
        for (int j = 0; j < e; j += 2) {
            if (i != omit) {
                int eb = edges[j];
                int ea = edges[j + 1];
                if (eb < ea) {
                    int tmp = eb;
                    eb = ea;
                    ea = tmp;
                }
                int pa = MSTSplit.follow(ea, idx);
                int pb = MSTSplit.follow(eb, idx);
                assert (pa != pb) : "Must be disjoint - MST inconsistent.";
                int n = idx[pa];
                sizes[n] = sizes[n] + sizes[idx[pb]];
                idx[pb] = idx[pa];
            }
            ++i;
        }
    }

    private static int follow(int i, int[] partitions) {
        int next = partitions[i];
        while (i != next) {
            int tmp = next;
            next = partitions[i] = partitions[next];
            i = tmp;
        }
        return i;
    }
}

