/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.strategies.split;

import elki.index.tree.metrical.mtreevariants.AbstractMTree;
import elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.strategies.split.AbstractMTreeSplit;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="Proc. Int. Conf. Very Large Data Bases (VLDB'97)", url="http://www.vldb.org/conf/1997/P426.PDF", bibkey="DBLP:conf/vldb/CiacciaPZ97")
public class RandomSplit<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
extends AbstractMTreeSplit<E, N> {
    private Random random;

    public RandomSplit(DistributionStrategy distributor, RandomFactory rnd) {
        super(distributor);
        this.random = rnd.getSingleThreadedRandom();
    }

    @Override
    public Assignments<E> split(AbstractMTree<?, N, E, ?> tree, N node) {
        int n = node.getNumEntries();
        int pos1 = this.random.nextInt(n);
        int pos2 = this.random.nextInt(n - 1);
        pos2 = pos2 >= pos1 ? pos2 + 1 : pos2;
        double[] dis1 = new double[n];
        double[] dis2 = new double[n];
        MTreeEntry e1 = (MTreeEntry)node.getEntry(pos1);
        MTreeEntry e2 = (MTreeEntry)node.getEntry(pos2);
        for (int i = 0; i < n; ++i) {
            if (i == pos1 || i == pos2) continue;
            MTreeEntry ej = (MTreeEntry)node.getEntry(i);
            dis1[i] = tree.distance(e1, ej);
            dis2[i] = tree.distance(e2, ej);
        }
        return this.distributor.distribute(node, pos1, dis1, pos2, dis2);
    }

    public static class Par<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
    extends AbstractMTreeSplit.Par<E, N> {
        public static final OptionID RANDOM_ID = new OptionID("mtree.randomsplit.random", "Random generator / seed for the randomized split.");
        RandomFactory rnd = RandomFactory.DEFAULT;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            new RandomParameter(RANDOM_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        @Override
        public RandomSplit<E, N> make() {
            return new RandomSplit(this.distributor, this.rnd);
        }
    }
}

