/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.metrical.mtreevariants.strategies.split.distribution;

import elki.database.ids.DBID;
import elki.index.tree.metrical.mtreevariants.MTreeEntry;
import elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistanceEntry;
import java.util.ArrayList;
import java.util.List;

public class Assignments<E extends MTreeEntry> {
    private DBID id1;
    private DBID id2;
    private List<DistanceEntry<E>> firstAssignments;
    private List<DistanceEntry<E>> secondAssignments;

    public Assignments(DBID id1, DBID id2, int size) {
        this.id1 = id1;
        this.id2 = id2;
        this.firstAssignments = new ArrayList<DistanceEntry<E>>(size);
        this.secondAssignments = new ArrayList<DistanceEntry<E>>(size);
    }

    public void addToFirst(E ent, double dist) {
        this.firstAssignments.add(new DistanceEntry<E>(ent, dist));
    }

    public double computeFirstCover(boolean leaf) {
        double max = 0.0;
        for (DistanceEntry<E> e : this.firstAssignments) {
            double cover = leaf ? e.getDistance() : ((MTreeEntry)e.getEntry()).getCoveringRadius() + e.getDistance();
            max = cover > max ? cover : max;
        }
        return max;
    }

    public double computeSecondCover(boolean leaf) {
        double max = 0.0;
        for (DistanceEntry<E> e : this.secondAssignments) {
            double cover = leaf ? e.getDistance() : ((MTreeEntry)e.getEntry()).getCoveringRadius() + e.getDistance();
            max = cover > max ? cover : max;
        }
        return max;
    }

    public void addToSecond(E ent, double dist) {
        this.secondAssignments.add(new DistanceEntry<E>(ent, dist));
    }

    public DBID getFirstRoutingObject() {
        return this.id1;
    }

    public DBID getSecondRoutingObject() {
        return this.id2;
    }

    public List<DistanceEntry<E>> getFirstAssignments() {
        return this.firstAssignments;
    }

    public List<DistanceEntry<E>> getSecondAssignments() {
        return this.secondAssignments;
    }
}

