/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.knn;

import elki.database.ids.DBIDRef;
import elki.database.ids.KNNList;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import elki.logging.Logging;

public class PreprocessorKNNQuery
implements KNNSearcher<DBIDRef> {
    private static final Logging LOG = Logging.getLogger(PreprocessorKNNQuery.class);
    protected final Relation<?> relation;
    private final AbstractMaterializeKNNPreprocessor<?> preprocessor;
    private boolean warned = false;

    public PreprocessorKNNQuery(Relation<?> relation, AbstractMaterializeKNNPreprocessor<?> preprocessor) {
        this.relation = relation;
        this.preprocessor = preprocessor;
    }

    public KNNList getKNN(DBIDRef id, int k) {
        KNNList knnList;
        if (!this.warned && k > this.preprocessor.getK()) {
            this.getLogger().warning((CharSequence)("Requested more neighbors than preprocessed: requested " + k + " preprocessed " + this.preprocessor.getK()), new Throwable());
            this.warned = true;
        }
        return (knnList = this.preprocessor.get(id)) != null ? knnList.subList(k) : null;
    }

    public AbstractMaterializeKNNPreprocessor<?> getPreprocessor() {
        return this.preprocessor;
    }

    protected Logging getLogger() {
        return LOG;
    }
}

