/*
 * Decompiled with CFR 0.152.
 */
package elki.database.query.rknn;

import elki.database.ids.DBIDRef;
import elki.database.ids.DoubleDBIDList;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.relation.Relation;
import elki.index.preprocessed.knn.MaterializeKNNAndRKNNPreprocessor;
import elki.logging.LoggingUtil;

public class PreprocessorRKNNQuery<O>
implements RKNNSearcher<DBIDRef> {
    protected final Relation<? extends O> relation;
    private final MaterializeKNNAndRKNNPreprocessor<O> preprocessor;
    private boolean warned = false;

    public PreprocessorRKNNQuery(Relation<O> relation, MaterializeKNNAndRKNNPreprocessor<O> preprocessor) {
        this.relation = relation;
        this.preprocessor = preprocessor;
    }

    public PreprocessorRKNNQuery(Relation<O> database, MaterializeKNNAndRKNNPreprocessor.Factory<O> preprocessor) {
        this(database, (MaterializeKNNAndRKNNPreprocessor<O>)preprocessor.instantiate((Relation)database));
    }

    public DoubleDBIDList getRKNN(DBIDRef id, int k) {
        if (!this.warned && k != this.preprocessor.getK()) {
            LoggingUtil.warning((String)"Requested more neighbors than preprocessed!");
        }
        return this.preprocessor.getRKNN(id);
    }
}

