/*
 * Decompiled with CFR 0.152.
 */
package elki.distance;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.distance.AbstractIndexBasedDistance;
import elki.index.Index;
import elki.index.preprocessed.snn.SharedNearestNeighborIndex;
import elki.index.preprocessed.snn.SharedNearestNeighborPreprocessor;
import elki.utilities.optionhandling.parameterization.Parameterization;

public class SharedNearestNeighborJaccardDistance<O>
extends AbstractIndexBasedDistance<O, SharedNearestNeighborIndex.Factory<O>> {
    public SharedNearestNeighborJaccardDistance(SharedNearestNeighborIndex.Factory<O> indexFactory) {
        super(indexFactory);
    }

    public <T extends O> Instance<T> instantiate(Relation<T> database) {
        Index indexi = ((SharedNearestNeighborIndex.Factory)this.indexFactory).instantiate((Relation)database);
        return new Instance<T>(database, indexi, this);
    }

    public static class Par<O>
    extends AbstractIndexBasedDistance.Par<SharedNearestNeighborIndex.Factory<O>> {
        public void configure(Parameterization config) {
            super.configure(config);
            this.configIndexFactory(config, SharedNearestNeighborIndex.Factory.class, SharedNearestNeighborPreprocessor.Factory.class);
        }

        public SharedNearestNeighborJaccardDistance<O> make() {
            return new SharedNearestNeighborJaccardDistance((SharedNearestNeighborIndex.Factory)this.factory);
        }
    }

    public static class Instance<T>
    extends AbstractIndexBasedDistance.Instance<T, SharedNearestNeighborIndex<T>, SharedNearestNeighborJaccardDistance<T>> {
        public Instance(Relation<T> database, SharedNearestNeighborIndex<T> preprocessor, SharedNearestNeighborJaccardDistance<T> parent) {
            super(database, preprocessor, parent);
        }

        protected static double jaccardCoefficient(DBIDs neighbors1, DBIDs neighbors2) {
            int intersection = 0;
            int union = 0;
            DBIDIter iter1 = neighbors1.iter();
            DBIDIter iter2 = neighbors2.iter();
            while (iter1.valid() && iter2.valid()) {
                int comp = DBIDUtil.compare((DBIDRef)iter1, (DBIDRef)iter2);
                ++union;
                if (comp == 0) {
                    ++intersection;
                    iter1.advance();
                    iter2.advance();
                    continue;
                }
                if (comp < 0) {
                    iter1.advance();
                    continue;
                }
                iter2.advance();
            }
            while (iter1.valid()) {
                ++union;
                iter1.advance();
            }
            while (iter2.valid()) {
                ++union;
                iter2.advance();
            }
            return (double)intersection / (double)union;
        }

        public double distance(DBIDRef id1, DBIDRef id2) {
            return 1.0 - Instance.jaccardCoefficient((DBIDs)((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(id1), (DBIDs)((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(id2));
        }
    }
}

