/*
 * Decompiled with CFR 0.152.
 */
package elki.index.distancematrix;

import elki.data.type.TypeInformation;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.PrioritySearcher;
import elki.database.query.distance.DatabaseDistanceQuery;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.index.DistanceIndex;
import elki.index.DistancePriorityIndex;
import elki.index.IndexFactory;
import elki.index.KNNIndex;
import elki.index.RangeIndex;
import elki.logging.Logging;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.utilities.datastructures.QuickSelect;
import elki.utilities.datastructures.arrays.DoubleIntegerArrayQuickSort;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.lang.ref.WeakReference;

public class PrecomputedDistanceMatrix<O>
implements DistanceIndex<O>,
RangeIndex<O>,
KNNIndex<O>,
DistancePriorityIndex<O> {
    private static final Logging LOG = Logging.getLogger(PrecomputedDistanceMatrix.class);
    protected final WeakReference<Relation<O>> refrelation;
    protected final Distance<? super O> distance;
    private double[] matrix = null;
    private DBIDRange ids;

    public PrecomputedDistanceMatrix(Relation<O> relation, DBIDRange range, Distance<? super O> distance) {
        this.refrelation = new WeakReference<Relation<O>>(relation);
        this.ids = range;
        this.distance = distance;
        if (!distance.isSymmetric()) {
            throw new AbortException("Distance matrixes currently only support symmetric distance functions (Patches welcome).");
        }
    }

    public void initialize() {
        if (this.ids.size() > 65536) {
            throw new AbortException("Distance matrixes currently have a limit of 65536 objects (~16 GB). After this, the array size exceeds the Java integer range, and a different data structure needs to be used.");
        }
        DistanceQuery distanceQuery = this.distance.instantiate((Relation)this.refrelation.get());
        int msize = PrecomputedDistanceMatrix.triangleSize(this.ids.size());
        this.matrix = new double[msize];
        DBIDArrayIter ix = this.ids.iter();
        DBIDArrayIter iy = this.ids.iter();
        Duration timer = LOG.newDuration(this.getClass().getName() + ".precomputation-time").begin();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Precomputing distance matrix", msize, LOG) : null;
        int pos = 0;
        ix.seek(0);
        while (ix.valid()) {
            iy.seek(0);
            while (iy.getOffset() < ix.getOffset()) {
                this.matrix[pos++] = distanceQuery.distance((DBIDRef)ix, (DBIDRef)iy);
                iy.advance();
            }
            if (prog != null) {
                prog.setProcessed(prog.getProcessed() + ix.getOffset(), LOG);
            }
            ix.advance();
        }
        LOG.ensureCompleted(prog);
        LOG.statistics((Statistic)timer.end());
    }

    protected static int triangleSize(int x) {
        return x * (x - 1) >>> 1;
    }

    private int getOffset(int x, int y) {
        return y < x ? PrecomputedDistanceMatrix.triangleSize(x) + y : PrecomputedDistanceMatrix.triangleSize(y) + x;
    }

    public void logStatistics() {
        if (this.matrix != null) {
            LOG.statistics((Statistic)new LongStatistic(this.getClass().getName() + ".matrix-size", (long)this.matrix.length));
        }
    }

    public DistanceQuery<O> getDistanceQuery(Distance<? super O> distanceFunction) {
        return this.distance.equals(distanceFunction) ? new PrecomputedDistanceQuery() : null;
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    public KNNSearcher<DBIDRef> kNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return this.distance.equals((Object)distanceQuery.getDistance()) ? new PrecomputedKNNQuery() : null;
    }

    public RangeSearcher<O> rangeByObject(DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        return null;
    }

    public RangeSearcher<DBIDRef> rangeByDBID(DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        return this.distance.equals((Object)distanceQuery.getDistance()) ? new PrecomputedRangeQuery() : null;
    }

    public PrioritySearcher<O> priorityByObject(DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        return null;
    }

    public PrioritySearcher<DBIDRef> priorityByDBID(DistanceQuery<O> distanceQuery, double maxrange, int flags) {
        return this.distance.equals((Object)distanceQuery.getDistance()) ? new PrecomputedDistancePrioritySearcher() : null;
    }

    public static class Factory<O>
    implements IndexFactory<O> {
        protected final Distance<? super O> distance;

        public Factory(Distance<? super O> distance) {
            this.distance = distance;
        }

        public PrecomputedDistanceMatrix<O> instantiate(Relation<O> relation) {
            DBIDs rids = relation.getDBIDs();
            if (!(rids instanceof DBIDRange)) {
                throw new AbortException("Distance matrixes are currently only supported for DBID ranges (as used by static databases; not on modifiable databases) for performance reasons (Patches welcome).");
            }
            return new PrecomputedDistanceMatrix<O>(relation, (DBIDRange)rids, this.distance);
        }

        public TypeInformation getInputTypeRestriction() {
            return this.distance.getInputTypeRestriction();
        }

        public static class Par<O>
        implements Parameterizer {
            public static final OptionID DISTANCE_ID = new OptionID("matrix.distance", "Distance function for the precomputed distance matrix.");
            protected Distance<? super O> distanceFunction;

            public void configure(Parameterization config) {
                new ObjectParameter(DISTANCE_ID, Distance.class).grab(config, x -> {
                    this.distanceFunction = x;
                });
            }

            public Factory<O> make() {
                return new Factory<O>(this.distanceFunction);
            }
        }
    }

    public class PrecomputedDistancePrioritySearcher
    implements PrioritySearcher<DBIDRef>,
    QuickSelect.Adapter<PrecomputedDistancePrioritySearcher> {
        DBIDArrayIter it;
        int off;
        int sorted;
        int lbsorted;
        int upsorted;
        double threshold;
        int[] idx;
        double[] dists;

        public PrecomputedDistancePrioritySearcher() {
            this.it = PrecomputedDistanceMatrix.this.ids.iter();
            this.idx = new int[PrecomputedDistanceMatrix.this.ids.size()];
            this.dists = new double[PrecomputedDistanceMatrix.this.ids.size()];
        }

        public PrioritySearcher<DBIDRef> search(DBIDRef query) {
            int y;
            this.off = 0;
            this.threshold = Double.POSITIVE_INFINITY;
            int x = PrecomputedDistanceMatrix.this.ids.getOffset(query);
            int pos = PrecomputedDistanceMatrix.triangleSize(x);
            this.idx[0] = x;
            for (y = 0; y < x; ++y) {
                this.idx[y + 1] = y;
            }
            int size = this.dists.length;
            for (y = x + 1; y < size; ++y) {
                this.idx[y] = y;
            }
            this.dists[0] = 0.0;
            System.arraycopy(PrecomputedDistanceMatrix.this.matrix, pos, this.dists, 1, x);
            pos = PrecomputedDistanceMatrix.triangleSize(x + 1) + x;
            y = x + 1;
            size = this.dists.length;
            while (y < size) {
                this.dists[y] = PrecomputedDistanceMatrix.this.matrix[pos];
                pos += y++;
            }
            this.sorted = 1;
            return this;
        }

        private void partialSort(int target) {
            if (this.sorted < target) {
                this.lbsorted = target - 1;
                this.upsorted = target;
                QuickSelect.quickSelect((Object)this, (QuickSelect.Adapter)this, (int)this.sorted, (int)this.dists.length, (int)(target - 1));
                if (this.sorted < this.lbsorted) {
                    DoubleIntegerArrayQuickSort.sort((double[])this.dists, (int[])this.idx, (int)this.sorted, (int)this.lbsorted);
                }
                this.sorted = this.upsorted;
            }
        }

        public PrioritySearcher<DBIDRef> advance() {
            if (++this.off >= this.sorted) {
                this.partialSort(Math.min(this.sorted == 1 ? 10 : this.sorted + (this.sorted >>> 1), this.dists.length));
            }
            return this;
        }

        public boolean valid() {
            return this.off < PrecomputedDistanceMatrix.this.ids.size() && this.dists[this.off] <= this.threshold;
        }

        public PrioritySearcher<DBIDRef> decreaseCutoff(double threshold) {
            this.threshold = threshold;
            return this;
        }

        public int internalGetIndex() {
            return this.it.seek(this.idx[this.off]).internalGetIndex();
        }

        public double computeExactDistance() {
            return this.dists[this.off];
        }

        public double getApproximateDistance() {
            return this.dists[this.off];
        }

        public double getApproximateAccuracy() {
            return 0.0;
        }

        public double getLowerBound() {
            return this.dists[this.off];
        }

        public double getUpperBound() {
            return this.dists[this.off];
        }

        public double allLowerBound() {
            return this.off < this.idx.length ? 0.0 : Double.POSITIVE_INFINITY;
        }

        public int compare(PrecomputedDistancePrioritySearcher data, int i, int j) {
            return Double.compare(this.dists[i], this.dists[j]);
        }

        public void swap(PrecomputedDistancePrioritySearcher data, int i, int j) {
            int tmp = this.idx[i];
            this.idx[i] = this.idx[j];
            this.idx[j] = tmp;
            double tmp2 = this.dists[i];
            this.dists[i] = this.dists[j];
            this.dists[j] = tmp2;
        }

        public void isSorted(PrecomputedDistancePrioritySearcher data, int begin, int end) {
            this.lbsorted = begin < this.lbsorted && end >= this.lbsorted ? begin : this.lbsorted;
            this.upsorted = begin <= this.upsorted && end > this.upsorted ? end : this.upsorted;
        }
    }

    public class PrecomputedKNNQuery
    implements KNNSearcher<DBIDRef> {
        DBIDArrayIter it;

        public PrecomputedKNNQuery() {
            this.it = PrecomputedDistanceMatrix.this.ids.iter();
        }

        public KNNList getKNN(DBIDRef id, int k) {
            KNNHeap heap = DBIDUtil.newHeap((int)k);
            heap.insert(0.0, id);
            double max = Double.POSITIVE_INFINITY;
            int x = PrecomputedDistanceMatrix.this.ids.getOffset(id);
            int pos = PrecomputedDistanceMatrix.triangleSize(x);
            int y = 0;
            while (y < x) {
                double dist = PrecomputedDistanceMatrix.this.matrix[pos];
                max = dist <= max ? heap.insert(dist, (DBIDRef)this.it.seek(y)) : max;
                ++y;
                ++pos;
            }
            assert (pos == PrecomputedDistanceMatrix.triangleSize(x + 1));
            pos = PrecomputedDistanceMatrix.triangleSize(x + 1) + x;
            y = x + 1;
            int size = PrecomputedDistanceMatrix.this.ids.size();
            while (y < size) {
                double dist = PrecomputedDistanceMatrix.this.matrix[pos];
                max = dist <= max ? heap.insert(dist, (DBIDRef)this.it.seek(y)) : max;
                pos += y++;
            }
            return heap.toKNNList();
        }
    }

    public class PrecomputedRangeQuery
    implements RangeSearcher<DBIDRef> {
        DBIDArrayIter it;

        public PrecomputedRangeQuery() {
            this.it = PrecomputedDistanceMatrix.this.ids.iter();
        }

        public ModifiableDoubleDBIDList getRange(DBIDRef id, double range, ModifiableDoubleDBIDList result) {
            result.add(0.0, id);
            int x = PrecomputedDistanceMatrix.this.ids.getOffset(id);
            int pos = PrecomputedDistanceMatrix.triangleSize(x);
            int y = 0;
            while (y < x) {
                double dist = PrecomputedDistanceMatrix.this.matrix[pos];
                if (dist <= range) {
                    result.add(dist, (DBIDRef)this.it.seek(y));
                }
                ++y;
                ++pos;
            }
            assert (pos == PrecomputedDistanceMatrix.triangleSize(x + 1));
            pos = PrecomputedDistanceMatrix.triangleSize(x + 1) + x;
            y = x + 1;
            int size = PrecomputedDistanceMatrix.this.ids.size();
            while (y < size) {
                double dist = PrecomputedDistanceMatrix.this.matrix[pos];
                if (dist <= range) {
                    result.add(dist, (DBIDRef)this.it.seek(y));
                }
                pos += y++;
            }
            return result;
        }
    }

    public class PrecomputedDistanceQuery
    implements DatabaseDistanceQuery<O> {
        public double distance(DBIDRef id1, DBIDRef id2) {
            int y;
            int x = PrecomputedDistanceMatrix.this.ids.getOffset(id1);
            return x != (y = PrecomputedDistanceMatrix.this.ids.getOffset(id2)) ? PrecomputedDistanceMatrix.this.matrix[PrecomputedDistanceMatrix.this.getOffset(x, y)] : 0.0;
        }

        public Distance<? super O> getDistance() {
            return PrecomputedDistanceMatrix.this.distance;
        }

        public Relation<? extends O> getRelation() {
            return (Relation)PrecomputedDistanceMatrix.this.refrelation.get();
        }
    }
}

