/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.data.type.TypeInformation;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.knn.PreprocessorKNNQuery;
import elki.database.query.knn.PreprocessorSqrtKNNQuery;
import elki.database.query.knn.PreprocessorSquaredKNNQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.index.IndexFactory;
import elki.index.KNNIndex;
import elki.logging.Logging;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractMaterializeKNNPreprocessor<O>
implements KNNIndex<O> {
    protected final Relation<O> relation;
    protected final int k;
    protected final Distance<? super O> distance;
    protected final DistanceQuery<O> distanceQuery;
    protected WritableDataStore<KNNList> storage = null;

    public AbstractMaterializeKNNPreprocessor(Relation<O> relation, Distance<? super O> distance, int k) {
        this.k = k;
        this.relation = relation;
        this.distance = distance;
        this.distanceQuery = distance.instantiate(relation);
    }

    public AbstractMaterializeKNNPreprocessor(Relation<O> relation, DistanceQuery<O> distanceQuery, int k) {
        this.k = k;
        this.relation = relation;
        this.distance = distanceQuery.getDistance();
        this.distanceQuery = distanceQuery;
    }

    public DistanceQuery<O> getDistanceQuery() {
        return this.distanceQuery;
    }

    public int getK() {
        return this.k;
    }

    protected abstract void preprocess();

    public KNNList get(DBIDRef id) {
        if (this.storage == null) {
            if (this.getLogger().isDebugging()) {
                this.getLogger().debug((CharSequence)("Running kNN preprocessor: " + this.getClass()));
            }
            this.preprocess();
        }
        return (KNNList)this.storage.get(id);
    }

    void createStorage() {
        this.storage = DataStoreUtil.makeStorage((DBIDs)this.distanceQuery.getRelation().getDBIDs(), (int)2, KNNList.class);
    }

    public void initialize() {
        if (this.storage != null) {
            throw new UnsupportedOperationException("Preprocessor already ran.");
        }
        if (this.distanceQuery.getRelation().size() > 0) {
            this.preprocess();
        }
    }

    @Deprecated
    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    public PreprocessorKNNQuery kNNByDBID(DistanceQuery<O> distQ, int maxk, int flags) {
        if (this.relation == distQ.getRelation() && (maxk == Integer.MAX_VALUE || maxk <= this.k)) {
            Distance odist = distQ.getDistance();
            if (this.distance.equals((Object)odist)) {
                return new PreprocessorKNNQuery(this.relation, this);
            }
            if (EuclideanDistance.STATIC.equals(this.distance) && SquaredEuclideanDistance.STATIC.equals((Object)odist)) {
                return new PreprocessorSquaredKNNQuery(this.relation, this);
            }
            if (SquaredEuclideanDistance.STATIC.equals(this.distance) && EuclideanDistance.STATIC.equals((Object)odist)) {
                return new PreprocessorSqrtKNNQuery(this.relation, this);
            }
        }
        return null;
    }

    protected abstract Logging getLogger();

    public static abstract class Factory<O>
    implements IndexFactory<O> {
        public static final OptionID K_ID = new OptionID("materialize.k", "The number of nearest neighbors of an object to be materialized.");
        public static final OptionID DISTANCE_FUNCTION_ID = new OptionID("materialize.distance", "the distance function to materialize the nearest neighbors");
        protected int k;
        protected Distance<? super O> distance;

        public Factory(int k, Distance<? super O> distance) {
            this.k = k;
            this.distance = distance;
        }

        public abstract AbstractMaterializeKNNPreprocessor<O> instantiate(Relation<O> var1);

        public Distance<? super O> getDistance() {
            return this.distance;
        }

        public TypeInformation getInputTypeRestriction() {
            return this.distance.getInputTypeRestriction();
        }

        public static abstract class Par<O>
        implements Parameterizer {
            protected int k;
            protected Distance<? super O> distance;

            public void configure(Parameterization config) {
                ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                    this.k = x;
                });
                new ObjectParameter(DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                    this.distance = x;
                });
            }

            public abstract Factory<O> make();
        }
    }
}

