/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBID;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDBIDs;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.ids.SetDBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.rknn.PreprocessorRKNNQuery;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.index.RKNNIndex;
import elki.index.preprocessed.knn.MaterializeKNNPreprocessor;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;

@Title(value="Materialize kNN and RkNN Neighborhood preprocessor")
@Description(value="Materializes the k nearest neighbors and the reverse k nearest neighbors of objects of a database.")
public class MaterializeKNNAndRKNNPreprocessor<O>
extends MaterializeKNNPreprocessor<O>
implements RKNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(MaterializeKNNAndRKNNPreprocessor.class);
    private WritableDataStore<ModifiableDoubleDBIDList> storageRkNN;

    public MaterializeKNNAndRKNNPreprocessor(Relation<O> relation, Distance<? super O> distance, int k) {
        super(relation, distance, k);
    }

    @Override
    protected void preprocess() {
        this.createStorage();
        this.storageRkNN = DataStoreUtil.makeStorage((DBIDs)this.relation.getDBIDs(), (int)2, ModifiableDoubleDBIDList.class);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Materializing k nearest neighbors and reverse k nearest neighbors (k=" + this.k + ")", this.relation.size(), this.getLogger()) : null;
        this.materializeKNNAndRKNNs(DBIDUtil.ensureArray((DBIDs)this.relation.getDBIDs()), progress);
    }

    private void materializeKNNAndRKNNs(ArrayDBIDs ids, FiniteProgress progress) {
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            if (this.storageRkNN.get((DBIDRef)iter) == null) {
                this.storageRkNN.put((DBIDRef)iter, (Object)DBIDUtil.newDistanceDBIDList());
            }
            iter.advance();
        }
        DBIDArrayIter id = ids.iter();
        while (id.valid()) {
            KNNList kNNs = this.knnQuery.getKNN((Object)id, this.k);
            this.storage.put((DBIDRef)id, (Object)kNNs);
            DoubleDBIDListIter iter2 = kNNs.iter();
            while (iter2.valid()) {
                ((ModifiableDoubleDBIDList)this.storageRkNN.get((DBIDRef)iter2)).add(iter2.doubleValue(), (DBIDRef)id);
                iter2.advance();
            }
            LOG.incrementProcessed((AbstractProgress)progress);
            id.advance();
        }
        LOG.ensureCompleted(progress);
    }

    @Override
    protected void objectsInserted(DBIDs ids) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress(3) : null;
        ArrayDBIDs aids = DBIDUtil.ensureArray((DBIDs)ids);
        LOG.beginStep(stepprog, 1, "New insertions ocurred, materialize their new kNNs and RkNNs.");
        this.materializeKNNAndRKNNs(aids, null);
        LOG.beginStep(stepprog, 2, "New insertions ocurred, update the affected kNNs and RkNNs.");
        DBIDs rkNN_ids = this.updateKNNsAndRkNNs(ids);
        LOG.beginStep(stepprog, 3, "New insertions ocurred, inform listeners.");
        this.fireKNNsInserted(ids, rkNN_ids);
        LOG.setCompleted(stepprog);
    }

    private DBIDs updateKNNsAndRkNNs(DBIDs ids) {
        ArrayModifiableDBIDs rkNN_ids = DBIDUtil.newArray();
        ModifiableDBIDs oldids = DBIDUtil.difference((DBIDs)this.relation.getDBIDs(), (DBIDs)ids);
        DBIDIter id = oldids.iter();
        while (id.valid()) {
            KNNList oldkNNs = (KNNList)this.storage.get((DBIDRef)id);
            double knnDist = oldkNNs.getKNNDistance();
            KNNHeap heap = null;
            DBIDIter newid = ids.iter();
            while (newid.valid()) {
                double dist = this.distanceQuery.distance((DBIDRef)id, (DBIDRef)newid);
                if (dist <= knnDist) {
                    heap = heap != null ? heap : DBIDUtil.newHeap((KNNList)oldkNNs);
                    heap.insert(dist, (DBIDRef)newid);
                }
                newid.advance();
            }
            if (heap != null) {
                KNNList newkNNs = heap.toKNNList();
                this.storage.put((DBIDRef)id, (Object)newkNNs);
                ModifiableDoubleDBIDList added = DBIDUtil.newDistanceDBIDList();
                ModifiableDoubleDBIDList removed = DBIDUtil.newDistanceDBIDList();
                DoubleDBIDListIter olditer = oldkNNs.iter();
                DoubleDBIDListIter newiter = newkNNs.iter();
                while (olditer.valid() && newiter.valid()) {
                    double oldd;
                    if (DBIDUtil.equal((DBIDRef)olditer, (DBIDRef)newiter)) {
                        olditer.advance();
                        newiter.advance();
                        continue;
                    }
                    double newd = newiter.doubleValue();
                    if (newd < (oldd = olditer.doubleValue()) || newd == oldd && !oldkNNs.contains((DBIDRef)newiter)) {
                        added.add(newiter.doubleValue(), (DBIDRef)newiter);
                        newiter.advance();
                        continue;
                    }
                    if (oldd < newd || oldd == newd && !newkNNs.contains((DBIDRef)olditer)) {
                        removed.add(olditer.doubleValue(), (DBIDRef)olditer);
                        olditer.advance();
                        continue;
                    }
                    throw new IllegalStateException("Unexpected third case, needs debug!");
                }
                while (olditer.valid()) {
                    removed.add(olditer.doubleValue(), (DBIDRef)olditer);
                    olditer.advance();
                }
                while (newiter.valid()) {
                    added.add(newiter.doubleValue(), (DBIDRef)newiter);
                    newiter.advance();
                }
                DoubleDBIDListMIter newnn = added.iter();
                while (newnn.valid()) {
                    ((ModifiableDoubleDBIDList)this.storageRkNN.get((DBIDRef)newnn)).add(newnn.doubleValue(), (DBIDRef)id);
                    newnn.advance();
                }
                DoubleDBIDListMIter oldnn = removed.iter();
                while (oldnn.valid()) {
                    DoubleDBIDListMIter iter = ((ModifiableDoubleDBIDList)this.storageRkNN.get((DBIDRef)oldnn)).iter();
                    while (iter.valid()) {
                        if (DBIDUtil.equal((DBIDRef)iter, (DBIDRef)id)) {
                            iter.remove();
                            break;
                        }
                        iter.advance();
                    }
                    oldnn.advance();
                }
                rkNN_ids.add((DBIDRef)id);
            }
            id.advance();
        }
        return rkNN_ids;
    }

    @Override
    protected void objectsRemoved(DBIDs ids) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress(3) : null;
        LOG.beginStep(stepprog, 1, "New deletions ocurred, remove their materialized kNNs and RkNNs.");
        HashSetModifiableDBIDs kNNs = DBIDUtil.newHashSet();
        HashSetModifiableDBIDs rkNNs = DBIDUtil.newHashSet();
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            kNNs.addDBIDs((DBIDs)this.storage.get((DBIDRef)iter));
            this.storage.delete((DBIDRef)iter);
            rkNNs.addDBIDs((DBIDs)this.storageRkNN.get((DBIDRef)iter));
            this.storageRkNN.delete((DBIDRef)iter);
            iter.advance();
        }
        kNNs.removeDBIDs(ids);
        rkNNs.removeDBIDs(ids);
        LOG.beginStep(stepprog, 2, "New deletions ocurred, update the affected kNNs and RkNNs.");
        SetDBIDs idsSet = DBIDUtil.ensureSet((DBIDs)ids);
        DBIDMIter nn = kNNs.iter();
        while (nn.valid()) {
            ModifiableDoubleDBIDList rkNN = (ModifiableDoubleDBIDList)this.storageRkNN.get((DBIDRef)nn);
            DoubleDBIDListMIter it = rkNN.iter();
            while (it.valid()) {
                if (idsSet.contains((DBIDRef)it)) {
                    it.remove();
                    break;
                }
                it.advance();
            }
            nn.advance();
        }
        DBIDMIter reknn = rkNNs.iter();
        while (reknn.valid()) {
            KNNList rknnlist = this.knnQuery.getKNN((Object)reknn, this.k);
            if (rknnlist == null) {
                LOG.warning((CharSequence)("BUG in online kNN/RkNN maintainance: " + DBIDUtil.toString((DBIDRef)reknn) + " no longer in database."));
            } else {
                this.storage.put((DBIDRef)reknn, (Object)rknnlist);
                DoubleDBIDListIter it = rknnlist.iter();
                while (it.valid()) {
                    ModifiableDoubleDBIDList rstor = (ModifiableDoubleDBIDList)this.storageRkNN.get((DBIDRef)it);
                    if (!rstor.contains((DBIDRef)reknn)) {
                        rstor.add(it.doubleValue(), (DBIDRef)reknn);
                    }
                    it.advance();
                }
            }
            reknn.advance();
        }
        LOG.beginStep(stepprog, 3, "New deletions ocurred, inform listeners.");
        this.fireKNNsRemoved(ids, (DBIDs)rkNNs);
        LOG.setCompleted(stepprog);
    }

    public KNNList getKNN(DBID id) {
        return (KNNList)this.storage.get((DBIDRef)id);
    }

    public DoubleDBIDList getRKNN(DBIDRef id) {
        return ((ModifiableDoubleDBIDList)this.storageRkNN.get(id)).sort();
    }

    public RKNNSearcher<O> rkNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    public RKNNSearcher<DBIDRef> rkNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return this.relation == distanceQuery.getRelation() && this.distance.equals(distanceQuery.getDistance()) && maxk == this.k ? new PreprocessorRKNNQuery(this.relation, this) : null;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends MaterializeKNNPreprocessor.Factory<O> {
        public Factory(int k, Distance<? super O> distance) {
            super(k, distance);
        }

        @Override
        public MaterializeKNNAndRKNNPreprocessor<O> instantiate(Relation<O> relation) {
            return new MaterializeKNNAndRKNNPreprocessor<O>(relation, this.distance, this.k);
        }

        public static class Par<O>
        extends MaterializeKNNPreprocessor.Factory.Par<O> {
            @Override
            public Factory<O> make() {
                return new Factory(this.k, this.distance);
            }
        }
    }
}

